% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot-methods.R
\docType{methods}
\name{ASEset-gbarplot}
\alias{ASEset-gbarplot}
\alias{gbarplot}
\alias{gbarplot,ASEset-method}
\title{gbarplot ASEset objects}
\usage{
gbarplot(x, type = "count", strand = "*", verbose = FALSE, ...)
}
\arguments{
\item{x}{An \code{ASEset} object}

\item{type}{'count' or 'fraction'}

\item{strand}{four options, '+', '-', 'both' or '*'}

\item{verbose}{Makes function more talkative}

\item{...}{for simpler generics when extending function}
}
\description{
Generates gbarplots for ASEset objects. Two levels of plotting detail are
provided: a detailed gbarplot of read counts by allele useful for fewer
samples and SNPs, and a less detailed gbarplot of the fraction of imbalance,
useful for more samples and SNPs.
}
\details{
This function serves the same purpose as the normal barplot, but with
trellis graphics using lattice, to be able to integrate well with Gviz track
functionality.
}
\examples{

data(ASEset)
gbarplot(ASEset[1])

}
\seealso{
\itemize{ \item The \code{\link{ASEset}} class which the gbarplot
function can be called up on.  \item The \code{\link{barplot}} non trellis
barplot.  }
}
\author{
Jesper R. Gadin
}
\keyword{gbarplot}
