\name{readMicroRnaAFE}
\alias{readMicroRnaAFE}
\title{Read Agilent Feature Extraction txt data files }
\description{
 Read the data files generated by the Agilent Feature
 Extraction image analysis software
}
\usage{
	readMicroRnaAFE(targets,verbose=FALSE)
}
\arguments{
  \item{targets}{ 
	 A data frame that specifies experimental conditions
 	under which each sample has been obtained.
	 }
 \item{verbose}{logical, if \code{TRUE} prints out output}
	
}
\details{
  The function reads the *.txt files generated by the
  AFE Software using the 'read.maimages' function
  of 'limma' package.

  Data, colected with the Agilent Feature Extraction Software, are stored
  in a uRNAList object with the following components:

                - dd.micro\$TGS                       'gTotalGeneSignal'
                - dd.micro\$TPS                       'gTotalProbeSignal'
                - dd.micro\$meanS                     'gMeanSignal'
                - dd.micro\$procS                     'gProcessedSignal'
                - dd.micro\$targets                   'targets'
                - dd.micro\$genes\$ProbeName          'Probe Name'
                - dd.micro\$genes\$GeneName           'microRNA Name'
                - dd.micro\$genes\$ControlType        'FLAG to specify the sort of feature'
                - dd.micro\$other\$gIsGeneDetected    'FLAG IsGeneDetected'
                - dd.micro\$other\$gIsSaturated       'FLAG IsSaturated'
                - dd.micro\$other\$gIsFeatNonUnifOL   'FLAG IsFeatNonUnifOL'
                - dd.micro\$other\$gIsFeatPopnOL      'FLAG IsFeatPopnOL'
                - dd.micro\$other\$gBGMedianSignal    'gBGMedianSignal'
                - dd.micro\$other\$gBGUsed    	      'gBGUsed'
}
\value{
 A uRNAList containing the following elements:
  \item{uRNAList\$TGS }{matrix, 'gTotalGeneSignal'}
  \item{uRNAList\$TPS }{matrix, 'gTotalProbeSignal'}
  \item{uRNAList\$meanS}{matrix, 'gMeanSignal'}
  \item{uRNAList\$procS}{matrix, 'gProcessedSignal'}
  \item{uRNAList\$targets }{data.frame, 'FileName'}
  \item{uRNAList\$genes\$ProbeName }{character, 'AGilent Probe Name'}
  \item{uRNAList\$genes\$GeneName }{character, 'microRNA Name'}
  \item{uRNAList\$genes\$ControlType }{integer, '0'= Feature, '1'= Positive control, '-1'= Negative control}
  \item{uRNAList\$other\$gIsGeneDetected }{matrix, FLAG to classify signal if 'IsGeneDetected=1' or 'not=0'}
  \item{uRNAList\$other\$gIsSaturated }{matrix, FLAG to classify signal if 'IsSaturated = 1' or 'not=0'}
  \item{uRNAList\$other\$gIsFeatPopnOL }{matrix, FLAG to classify signal if 'IsFeatPopnOL = 0' or 'not=1'}
  \item{uRNAList\$other\$gIsFeatNonUnifOL }{matrix, FLAG to classify signal if 'gIsFeatNonUnifOL = 0' or 'not=1'}
  \item{uRNAList\$other\$gBGMedianSignal }{matrix, gBGMedianSignal } 
  \item{uRNAList\$other\$gBGUsed }{matrix, gBGUsed } 
}


\references{ 
	Agilent Feature Extraction Reference Guide
        \url{http://www.Agilent.com}
		
 	Smyth, G. K. (2005). Limma: linear models for microarray data. In:
        'Bioinformatics and Computational Biology Solutions using R and
        Bioconductor'. R. Gentleman, V. Carey, S. Dudoit, R. Irizarry, W.
        Huber (eds), Springer, New York, pages 397--420.

 }
\author{Pedro Lopez-Romero }
\seealso{ 
	A data example can be found in \code{dd.micro}
	See also \code{readTargets} to see how to build the target file and
        the example given in \code{targets.micro}
}
\examples{
\dontrun{
data(targets.micro)
dd.micro = readMicroRnaAFE(targets.micro)
}
}
\keyword{documentation }
\keyword{ utilities }
