% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{computeExpr}
\alias{computeExpr}
\title{Compute the imputed GReX for a certain gene on a set of individuals}
\usage{
computeExpr(bs, pcs)
}
\arguments{
\item{bs}{A list containing three objects:
\itemize{
 \item coefficients: An object containing the coefficients of the principal
 components used in the model, completely similar to the "coefficients"
 object from the results of lm()
 \item p.val: The uncorrected anova pvalue of the model
 \item r.sq: The coefficient of determination between the real total expression
 values and the imputed GReX, retrived from summary(model)$r.squared
}}

\item{pcs}{A list, which is the returning object of affiXcanPcs()}
}
\value{
A vector of imputed GReX values
}
\description{
Compute the imputed GReX for a certain gene on a set of individuals
}
\examples{
if (interactive()) {
trainingTbaPaths <- system.file("extdata","training.tba.toydata.rds",
package="AffiXcan")

data(exprMatrix)
data(regionAssoc)
data(trainingCovariates)

assay <- "values"

training <- affiXcanTrain(exprMatrix=exprMatrix, assay=assay,
tbaPaths=trainingTbaPaths, regionAssoc=regionAssoc, cov=trainingCovariates,
varExplained=80, scale=TRUE)

testingTbaPaths <- system.file("extdata","testing.tba.toydata.rds",
package="AffiXcan")

pcs <- affiXcanPcs(tbaPaths=testingTbaPaths, affiXcanTraining=training,
scale=TRUE)

region <- "ENSG00000256377.1"
bs <- training$bs[[region]]

exprmatrix <- computeExpr(bs=bs, pcs=pcs)
}
}
