% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{assoc2list}
\alias{assoc2list}
\title{Reorganize associations table in a list}
\usage{
assoc2list(gene, regionAssoc)
}
\arguments{
\item{gene}{A string; the name of an expressed gene}

\item{regionAssoc}{A data.frame with the associations between regulatory
regions and expressed genes, and with colnames = c("REGULATORY_REGION",
"EXPRESSED_REGION")}
}
\value{
A list of data frames, each of which has the same structure of the
param regionAssoc, except that contains the information relative to one
expressed gene
}
\description{
Reorganize associations table in a list
}
\examples{
if (interactive()) {
data(regionAssoc)
expressedRegions <- as.list(as.vector(unique(regionAssoc$EXPRESSED_REGION)))
gene <- expressedRegions[[1]]
assocList <- assoc2list(gene, regionAssoc)
}
}
