% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{affiXcanImpute}
\alias{affiXcanImpute}
\title{Impute a GReX for each gene for which a model was generated}
\usage{
affiXcanImpute(tbaPaths, affiXcanTraining, scale = TRUE, BPPARAM = bpparam())
}
\arguments{
\item{tbaPaths}{A vector of strings, which are the paths to
MultiAssayExperiment RDS files containing the tba values}

\item{affiXcanTraining}{The returning object from affiXcanTrain()}

\item{scale}{A logical; if scale=FALSE the TBA values will be only centered,
not scaled before performing PCA; default is TRUE}

\item{BPPARAM}{A BiocParallelParam object. Default is bpparam(). For
details on BiocParallelParam virtual base class see 
browseVignettes("BiocParallel")}
}
\value{
A SummarizedExperiment object containing imputed GReX values
}
\description{
Impute a GReX for each gene for which a model was generated
}
\examples{
trainingTbaPaths <- system.file("extdata","training.tba.toydata.rds",
package="AffiXcan")

data(exprMatrix)
data(regionAssoc)
data(trainingCovariates)

assay <- "values"

training <- affiXcanTrain(exprMatrix=exprMatrix, assay=assay,
tbaPaths=trainingTbaPaths, regionAssoc=regionAssoc,
varExplained=80, scale=TRUE)

testingTbaPaths <- system.file("extdata","testing.tba.toydata.rds",
package="AffiXcan")

exprmatrix <- affiXcanImpute(tbaPaths=testingTbaPaths,
affiXcanTraining=training, scale=TRUE)
}
