% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel}
\alias{writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel}
\title{writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt
files of each .FT2 file and write them to one tsv file}
\usage{
writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel(
  workingPath,
  topN = 5L,
  fileName = "a.tsv"
)
}
\arguments{
\item{workingPath}{a full path with .Spe2PepFile.txt files in it}

\item{topN}{store top N PSMs of each scan of one .FT2 file}

\item{fileName}{the output path}
}
\value{
nothing but write a tsv of top N PSMs
}
\description{
writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt
files of each .FT2 file and write them to one tsv file
}
\examples{
tmp <- tempdir()
sip_dir <- file.path(tmp, "sip")
dir.create(sip_dir)
demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3, file.path(sip_dir, "top3.tsv"))
list.files(sip_dir, full.names = TRUE)
print(file.info(file.path(sip_dir, "top3.tsv")))
}
