% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{writeAllScanMS1}
\alias{writeAllScanMS1}
\title{write all MS1 scans has charge}
\usage{
writeAllScanMS1(header, scansList, ftFile)
}
\arguments{
\item{header}{a list of FT file header}

\item{scansList}{a list of scans for output}

\item{ftFile}{a ft1 file's output path}
}
\value{
TRUE if the file was written successfully, FALSE otherwise
}
\description{
write all MS1 scans has charge
}
\examples{
rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
demo_file <- tempfile(fileext = ".FT1")
writeLines(readRDS(rds), demo_file)
header <- readFTheader(demo_file)
ft1 <- readAllScanMS1(demo_file)
tmp <- tempdir()
writeAllScanMS1(header, ft1[1:10], file.path(tmp, "demo10.FT1"))
list.files(tmp, pattern = "demo10.FT1", full.names = TRUE)
}
