% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scorePSMsimple}
\alias{scorePSMsimple}
\title{scorePSMsimple Score a PSM without isotopic envelope shape modeling}
\usage{
scorePSMsimple(
  realMZ,
  realIntensity,
  realCharge,
  parentCharge,
  pepSeq,
  Atom,
  Prob
)
}
\arguments{
\item{realMZ}{mz vector in MS2 scan}

\item{realIntensity}{intensity vector in MS2 scan}

\item{realCharge}{charge vector in MS2 scan}

\item{parentCharge}{precursor charge, 2 for example}

\item{pepSeq}{a string of peptide}

\item{Atom}{"C13" or "N15"}

\item{Prob}{its SIP abundance (0.0~1.0)}
}
\value{
a score of this PSM
}
\description{
scorePSMsimple Score a PSM without isotopic envelope shape modeling
}
\examples{
demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
scan1 <- readOneScanMS2(ftFile = demo_file, scanNumber = 107728)
score <- scorePSMsimple(
  scan1$peaks$mz,
  scan1$peaks$intensity,
  scan1$peaks$charge,
  2,
  "[HSQVFSTAEDNQSAVTIHVLQGER]",
  "C13",
  0.0107
)
}
