% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{readScansMS1Vector}
\alias{readScansMS1Vector}
\title{read MS1 scans with scanNumber as index in a vector}
\usage{
readScansMS1Vector(ftFile, scanNumbersVector)
}
\arguments{
\item{ftFile}{a ft1 file's full path}

\item{scanNumbersVector}{a NumericVector of scan numbers}
}
\value{
A named list of MS1 scans with names of scan number. The names of the list correspond to the scan numbers.
}
\description{
read MS1 scans with scanNumber as index in a vector
}
\examples{
rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
demo_file <- tempfile(fileext = ".FT1")
writeLines(readRDS(rds), demo_file)
ft1 <- readScansMS1Vector(demo_file, c(1398, 1503, 1508))
}
