% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAAspectra.R
\name{plotRealScan}
\alias{plotRealScan}
\title{plot real scan layer under the B Y ion peaks}
\usage{
plotRealScan(spect, linewidth = 0.1)
}
\arguments{
\item{spect}{AAspectra object of real scan}

\item{linewidth}{}
}
\value{
ggplot2 layer
}
\description{
plot real scan layer under the B Y ion peaks
}
\examples{
a <- getSipBYionSpectra("HSQVFSTAEDNQSAVTIHVLQGER", "C13", 0.01, 1:2)
p <- plot(a)
p <- p + plotSipBYionLabel(a)
demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
b <- readAllScanMS2(demo_file)
c <- getRealScan(107728, b)
p <- p + plotRealScan(c)
p
}
