% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIPmontecarlo.R
\name{plotMolecularIsotopes}
\alias{plotMolecularIsotopes}
\title{Plot Molecular Isotopes with fine structure by Montecarlo algorithm}
\usage{
plotMolecularIsotopes(
  isotope_numbers,
  charge = 1,
  minProb = 1e-04,
  jitterAmount = 0.03,
  yshift = -1,
  peakWidth = 0.5,
  labelN = 35,
  labelSize = 3,
  textSize = 15
)
}
\arguments{
\item{isotope_numbers}{A data.frame representing the isotope mass and abundance to be plotted.}

\item{charge}{An integer representing the charge of the molecule. Default is 1.}

\item{minProb}{A numeric value representing the minimum probability threshold for plotting. Default is 0.0001.}

\item{jitterAmount}{A numeric value representing the amount of jitter to be added to the plot for better visualization of adjacent MZ. Default is 0.03.}

\item{yshift}{A numeric value representing the vertical shift applied to the plot for better visualization of the abundance close to 0. Default is -1.}

\item{peakWidth}{A numeric value representing the isotopic peak width in the plot. Default is 0.5.}

\item{labelN}{An integer setting top N peaks to be annotated. Default is 35.}

\item{labelSize}{A numeric value representing the size of the isotopologues labels. Default is 3.}

\item{textSize}{A numeric value representing the size of the text in the plot. Default is 15.}
}
\value{
ggplot A ggplot object of molecular isotopes generated by Montecarlo algorithm.
}
\description{
This function generates a plot of molecular isotopes based on the provided isotope numbers.
}
\examples{
isotope_numbers <- cal_isotope_numbers_SIP("C6H12O6", num_simulations = 10000, C13 = 0.5)
plotMolecularIsotopes(isotope_numbers)
}
