% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extractPSMfeaturesTargetAndDecoytoPercolatorPin}
\alias{extractPSMfeaturesTargetAndDecoytoPercolatorPin}
\title{extractPSMfeaturesTargetAndDecoytoPercolatorPin extract featueres of top PSMs from target and decoy .Spe2Pep.txt files
to pecorlator pin format}
\usage{
extractPSMfeaturesTargetAndDecoytoPercolatorPin(
  targetPath,
  decoyPath,
  topN,
  ftFilepath,
  ThreadNumber = 3L,
  doProteinInference = FALSE,
  fileName = "a.pin"
)
}
\arguments{
\item{targetPath}{a full path with target .Spe2PepFile.txt files in it}

\item{decoyPath}{a full path with decoy .Spe2PepFile.txt files in it}

\item{topN}{store top N PSMs of each scan of one .FT2 file}

\item{ftFilepath}{a full path with .FT1 and .FT2 files in it}

\item{ThreadNumber}{read ThreadNumber of FT file at the same time, it will increase ram usage}

\item{doProteinInference}{out put protein inference format or only PSM format}

\item{fileName}{output path of the percolator tsv file}
}
\value{
NULL (invisibly).
}
\description{
extractPSMfeaturesTargetAndDecoytoPercolatorPin extract featueres of top PSMs from target and decoy .Spe2Pep.txt files
to pecorlator pin format
}
\details{
Set OpenMP stack size to avoid stack overflow in parallel processing before loading Aerith package:
Sys.setenv(OMP_STACKSIZE = "16M")
Sys.setenv(OMP_NUM_THREADS = parallel::detectCores())
}
\examples{
tmp <- tempdir()
target_dir <- file.path(tmp, "target")
dir.create(target_dir, showWarnings = FALSE)
target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
decoy_dir <- file.path(tmp, "decoy")
dir.create(decoy_dir, showWarnings = FALSE)
decoy_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
file.copy(decoy_file, file.path(decoy_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
ft_dir <- file.path(tmp, "ft")
dir.create(ft_dir, showWarnings = FALSE)
ft_file <- system.file("extdata", "demo_target_decoy.FT1.rds", package = "Aerith")
file_content <- readRDS(ft_file)
writeLines(file_content, file.path(ft_dir, "Pan_052322_X13.FT1"))
pin_path <- file.path(tmp, "a.pin")
extractPSMfeaturesTargetAndDecoytoPercolatorPin(target_dir, decoy_dir, 3, ft_dir, 3, FALSE, pin_path)
print(list.files(c(ft_dir, target_dir, decoy_dir), full.names = TRUE, recursive = TRUE))
print(file.info(pin_path))
}
