% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extractPSMfeatures}
\alias{extractPSMfeatures}
\title{extractPSMfeatures extract featueres of top PSMs from multiple .Spe2Pep.txt files}
\usage{
extractPSMfeatures(Spe2PepFilePath, topN, ftFilepath, ThreadNumber = 3L)
}
\arguments{
\item{Spe2PepFilePath}{a full path with .Spe2Pep.txt files in it}

\item{topN}{store top N PSMs of each scan of one .FT2 file}

\item{ftFilepath}{a full path with .FT1 and .FT2 files in it}

\item{ThreadNumber}{read ThreadNumber of FT file at the same time, it will increase ram usage}
}
\value{
A named list of data frames, each containing the extracted PSM features from the corresponding .Spe2Pep.txt file.
}
\description{
extractPSMfeatures extract featueres of top PSMs from multiple .Spe2Pep.txt files
}
\details{
Set OpenMP stack size to avoid stack overflow in parallel processing before loading Aerith package:
Sys.setenv(OMP_STACKSIZE = "16M")
Sys.setenv(OMP_NUM_THREADS = parallel::detectCores())
}
\examples{
tmp <- tempdir()
target_dir <- file.path(tmp, "target")
dir.create(target_dir, showWarnings = FALSE)
target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
ft_dir <- file.path(tmp, "ft")
dir.create(ft_dir, showWarnings = FALSE)
ft_file <- system.file("extdata", "demo_target_decoy.FT1.rds", package = "Aerith")
file_content <- readRDS(ft_file)
writeLines(file_content, file.path(ft_dir, "Pan_052322_X13.FT1"))
print(list.files(c(ft_dir, target_dir), full.names = TRUE, recursive = TRUE))
psm <- extractPSMfeatures(target_dir, 5, ft_dir, 3)
}
