% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{denoiseOneMS2ScanHasCharge}
\alias{denoiseOneMS2ScanHasCharge}
\title{denoise one MS2 scan has charge}
\usage{
denoiseOneMS2ScanHasCharge(scanList, window, step, threshold)
}
\arguments{
\item{scanList}{a list of one MS2 scan has charge}

\item{window}{a float of mz window size for denoise}

\item{step}{a float of mz step for denoise}

\item{threshold}{a float of top N threshold for denoise}
}
\value{
a denoised MS2 scan has charge
}
\description{
denoise one MS2 scan has charge
}
\examples{
demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
ft2 <- readAllScanMS2(demo_file)
plot(getRealScanFromList(ft2[["1346"]]))
ms2 <- denoiseOneMS2ScanHasCharge(ft2[["1346"]], 100, 10, 5)
plot(getRealScanFromList(ms2))
}
