% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIPmontecarlo.R
\name{cal_isotope_numbers}
\alias{cal_isotope_numbers}
\title{Calculate Isotope Numbers in natural abundance}
\usage{
cal_isotope_numbers(formula, num_simulations = 10000)
}
\arguments{
\item{formula}{A character string representing the chemical formula.}

\item{num_simulations}{An integer specifying the number of simulations to run. Default is 10,000.}
}
\value{
A data frame containing the results of the simulations.
}
\description{
This function calculates the isotope numbers for a given chemical formula
using a Monte Carlo simulation approach.
}
\examples{
cal_isotope_numbers("C6H12O6")
cal_isotope_numbers("CF3COOH", num_simulations = 5000)
}
