% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{annotatePSM}
\alias{annotatePSM}
\title{annotatePSM}
\usage{
annotatePSM(
  realMZ,
  realIntensity,
  realCharge,
  pepSeq,
  charges,
  Atom,
  Prob,
  isoCenter = 0,
  isoWidth = 0,
  calScores = FALSE
)
}
\arguments{
\item{realMZ}{mz vector in MS2 scan}

\item{realIntensity}{intensity vector in MS2 scan}

\item{realCharge}{charge vector in MS2 scan}

\item{pepSeq}{a string of peptide}

\item{charges}{charges of product ions in consideration}

\item{Atom}{"C13" or "N15"}

\item{Prob}{its SIP abundance (0.0~1.0)}

\item{isoCenter}{isolation window center, set it 0 as default if not remove peaks in isolation window}

\item{isoWidth}{isolation window width, set it 0 as default if not remove peaks in isolation window}

\item{calScores, }{FALSE as default, calculate WDP MVH Xcor scores or not}
}
\value{
a List about matched peaks information of this PSM
}
\description{
annotatePSM
}
\examples{
demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
scan1 <- readOneScanMS2(ftFile = demo_file, 107728)
anno <- annotatePSM(
  scan1$peaks$mz, scan1$peaks$intensity,
  scan1$peaks$charge,
  "HSQVFSTAEDNQSAVTIHVLQGER", 1:2, "C13",
  0.0107, 886.65, 4.0, TRUE
)
}
