# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' extractPSMfeatures extract featueres of top PSMs from multiple .Spe2Pep.txt files
#' @details
#' Set OpenMP stack size to avoid stack overflow in parallel processing before loading Aerith package:
#' Sys.setenv(OMP_STACKSIZE = "16M")
#' Sys.setenv(OMP_NUM_THREADS = parallel::detectCores())
#' @param Spe2PepFilePath a full path with .Spe2Pep.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @param ftFilepath a full path with .FT1 and .FT2 files in it
#' @param ThreadNumber read ThreadNumber of FT file at the same time, it will increase ram usage
#' @return A named list of data frames, each containing the extracted PSM features from the corresponding .Spe2Pep.txt file.
#' @examples
#' tmp <- tempdir()
#' target_dir <- file.path(tmp, "target")
#' dir.create(target_dir, showWarnings = FALSE)
#' target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' ft_dir <- file.path(tmp, "ft")
#' dir.create(ft_dir, showWarnings = FALSE)
#' ft_file <- system.file("extdata", "demo_target_decoy.FT1.rds", package = "Aerith")
#' file_content <- readRDS(ft_file)
#' writeLines(file_content, file.path(ft_dir, "Pan_052322_X13.FT1"))
#' print(list.files(c(ft_dir, target_dir), full.names = TRUE, recursive = TRUE))
#' psm <- extractPSMfeatures(target_dir, 5, ft_dir, 3)
#' @export
extractPSMfeatures <- function(Spe2PepFilePath, topN, ftFilepath, ThreadNumber = 3L) {
    .Call(`_Aerith_extractPSMfeatures`, Spe2PepFilePath, topN, ftFilepath, ThreadNumber)
}

#' extractPSMfeaturesTargetAndDecoy extract featueres of top PSMs from target and decoy .Spe2Pep.txt files
#' @details
#' Set OpenMP stack size to avoid stack overflow in parallel processing before loading Aerith package:
#' Sys.setenv(OMP_STACKSIZE = "16M")
#' Sys.setenv(OMP_NUM_THREADS = parallel::detectCores())
#' @param targetPath a full path with target .Spe2PepFile.txt files in it
#' @param decoyPath a full path with decoy .Spe2PepFile.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @param ftFilepath a full path with .FT1 and .FT2 files in it
#' @param ThreadNumber read ThreadNumber of FT file at the same time, it will increase ram usage
#' @return the PSMs in a dataframe in a list
#' @examples
#' tmp <- tempdir()
#' target_dir <- file.path(tmp, "target")
#' dir.create(target_dir, showWarnings = FALSE)
#' target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' decoy_dir <- file.path(tmp, "decoy")
#' dir.create(decoy_dir, showWarnings = FALSE)
#' decoy_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(decoy_file, file.path(decoy_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' ft_dir <- file.path(tmp, "ft")
#' dir.create(ft_dir, showWarnings = FALSE)
#' ft_file <- system.file("extdata", "demo_target_decoy.FT1.rds", package = "Aerith")
#' file_content <- readRDS(ft_file)
#' writeLines(file_content, file.path(ft_dir, "Pan_052322_X13.FT1"))
#' print(list.files(c(ft_dir, target_dir, decoy_dir), full.names = TRUE, recursive = TRUE))
#' psm <- extractPSMfeaturesTargetAndDecoy(target_dir, decoy_dir, 3, ft_dir, 3)
#' @export
extractPSMfeaturesTargetAndDecoy <- function(targetPath, decoyPath, topN, ftFilepath, ThreadNumber = 3L) {
    .Call(`_Aerith_extractPSMfeaturesTargetAndDecoy`, targetPath, decoyPath, topN, ftFilepath, ThreadNumber)
}

#' extractPSMfeaturesTargetAndDecoytoPercolatorPin extract featueres of top PSMs from target and decoy .Spe2Pep.txt files
#' to pecorlator pin format
#' @details
#' Set OpenMP stack size to avoid stack overflow in parallel processing before loading Aerith package:
#' Sys.setenv(OMP_STACKSIZE = "16M")
#' Sys.setenv(OMP_NUM_THREADS = parallel::detectCores())
#' @param targetPath a full path with target .Spe2PepFile.txt files in it
#' @param decoyPath a full path with decoy .Spe2PepFile.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @param ftFilepath a full path with .FT1 and .FT2 files in it
#' @param ThreadNumber read ThreadNumber of FT file at the same time, it will increase ram usage
#' @param doProteinInference out put protein inference format or only PSM format
#' @param fileName output path of the percolator tsv file
#' @return NULL (invisibly).
#' @examples
#' tmp <- tempdir()
#' target_dir <- file.path(tmp, "target")
#' dir.create(target_dir, showWarnings = FALSE)
#' target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' decoy_dir <- file.path(tmp, "decoy")
#' dir.create(decoy_dir, showWarnings = FALSE)
#' decoy_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(decoy_file, file.path(decoy_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' ft_dir <- file.path(tmp, "ft")
#' dir.create(ft_dir, showWarnings = FALSE)
#' ft_file <- system.file("extdata", "demo_target_decoy.FT1.rds", package = "Aerith")
#' file_content <- readRDS(ft_file)
#' writeLines(file_content, file.path(ft_dir, "Pan_052322_X13.FT1"))
#' pin_path <- file.path(tmp, "a.pin")
#' extractPSMfeaturesTargetAndDecoytoPercolatorPin(target_dir, decoy_dir, 3, ft_dir, 3, FALSE, pin_path)
#' print(list.files(c(ft_dir, target_dir, decoy_dir), full.names = TRUE, recursive = TRUE))
#' print(file.info(pin_path))
#' @export
extractPSMfeaturesTargetAndDecoytoPercolatorPin <- function(targetPath, decoyPath, topN, ftFilepath, ThreadNumber = 3L, doProteinInference = FALSE, fileName = "a.pin") {
    invisible(.Call(`_Aerith_extractPSMfeaturesTargetAndDecoytoPercolatorPin`, targetPath, decoyPath, topN, ftFilepath, ThreadNumber, doProteinInference, fileName))
}

#' getUnfilteredPSMs
#' @param sipPath a full path with .sip files in it
#' @param ftPath a full path with .ft files in it
#' @param topN store top N PSMs of each scan of one .FT file
#' @return data.frame of PSMs
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' head(getUnfilteredPSMs(demo_dir, demo_dir, 10))
#' @export
getUnfilteredPSMs <- function(sipPath, ftPath, topN) {
    .Call(`_Aerith_getUnfilteredPSMs`, sipPath, ftPath, topN)
}

#' getUnfilteredPeptides
#' @param workingPath a full path with .sip files in it
#' @return a dataframe of unique peptides and whether it is decoy sequence
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' head(getUnfilteredPeptides(demo_dir))
#' @export
getUnfilteredPeptides <- function(workingPath) {
    .Call(`_Aerith_getUnfilteredPeptides`, workingPath)
}

#' getFilterThreshold
#' @param workingPath a full path with .sip files in it
#' @param OverallThreshold FDR thredhold of peptides
#' @return a dataframe about filter threshold and FDR results
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' getFilterThreshold(demo_dir, 0.01)
#' @export
getFilterThreshold <- function(workingPath, OverallThreshold) {
    .Call(`_Aerith_getFilterThreshold`, workingPath, OverallThreshold)
}

#' getFilterThresholdTopPSMs get filter threshold of top PSMs of each scan from multiple .sip file
#' @param workingPath a full path with .sip files in it
#' @param OverallThreshold FDR thredhold of peptides
#' @param topN store top N PSMs of each scan of one .FT file
#' @return a dataframe about filter threshold and FDR results
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' re <- getFilterThresholdTopPSMs(demo_dir, 0.01, 3)
#' re$threshold
#' head(re$topPSMs)
#' @export
getFilterThresholdTopPSMs <- function(workingPath, OverallThreshold, topN) {
    .Call(`_Aerith_getFilterThresholdTopPSMs`, workingPath, OverallThreshold, topN)
}

#' getFilterThresholdTopPSMsSpe2Pep get filter threshold of top PSMs of each scan from multiple .sip file
#' @param workingPath a full path with .Spe2Pep files in it
#' @param OverallThreshold FDR thredhold of peptides
#' @param topN store top N PSMs of each scan of one .FT file
#' @param decoyPrefix the prefix of decoy sequence
#' @return a dataframe about filter threshold and FDR results, 
#' rows of "<charge>, 0, 0 ,0" means cannot find threshold at this charge
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' list.files(sip_dir, full.names = TRUE)
#' a <- getFilterThresholdTopPSMsSpe2Pep(sip_dir, 1, 3, "Decoy_")
#' a$threshold
#' @export
getFilterThresholdTopPSMsSpe2Pep <- function(workingPath, OverallThreshold, topN, decoyPrefix) {
    .Call(`_Aerith_getFilterThresholdTopPSMsSpe2Pep`, workingPath, OverallThreshold, topN, decoyPrefix)
}

#' generateOneCFG
#' @param cfgPath a full path of .cfg file
#' @param outPath a full path for .cfg file output
#' @param element a string of element name, "N" for example
#' @param pct a integer of element SIP abundance
#' @param center a integer of mass window center
#' @param width a integer of mass half window width
#' @return a bool value if generate succeed or not
#' @examples
#' cfg <- system.file("extdata", "SiprosConfig.cfg", package = "Aerith")
#' tmp <- tempdir()
#' tmp <- file.path(tmp, "configs")
#' generateOneCFG(cfg, tmp, "N", 50, 0, 2)
#' list.files(tmp, full.names = TRUE)
#' @export
generateOneCFG <- function(cfgPath, outPath, element, pct, center, width) {
    .Call(`_Aerith_generateOneCFG`, cfgPath, outPath, element, pct, center, width)
}

#' generateCFGs
#' @param cfgPath a full path of .cfg file
#' @param outPath a full path for .cfg file output
#' @param element a string of element name, "N" for example
#' @return a bool value if generate succeed or not
#' @examples
#' cfg <- system.file("extdata", "SiprosConfig.cfg", package = "Aerith")
#' tmp <- tempdir()
#' tmp <- file.path(tmp, "configs")
#' generateCFGs(cfg, tmp, "N")
#' list.files(tmp, full.names = TRUE)
#' @export
generateCFGs <- function(cfgPath, outPath, element) {
    .Call(`_Aerith_generateCFGs`, cfgPath, outPath, element)
}

#' @title Precursor Peak Calculator
#' @description This function calculates the isotopic distribution of a given amino acid string and returns a DataFrame containing the mass and probability of each isotope.
#' @param AAstr A string representing the amino acid sequence.
#' @return A DataFrame with two columns: "Mass" containing the mass of each isotope and "Prob" containing the probability of each isotope.
#' @examples
#' a <- precursor_peak_calculator("PEPTIDE")
#' @export
precursor_peak_calculator <- function(AAstr) {
    .Call(`_Aerith_precursor_peak_calculator`, AAstr)
}

#' Simple residue peak calculator of user defined isotopic distribution of one residue
#' @param residue residue name
#' @param Atom isotopes of "C13", "N15", "H2", "O18", "S34"
#' @param Prob its SIP abundance (0.0~1.0)
#' @return A DataFrame with two columns: "Mass" containing the mass of each isotope and "Prob" containing the probability of each isotope.
#' @examples
#' df <- residue_peak_calculator_DIY("A", "C13", 0.2)
#' @export
residue_peak_calculator_DIY <- function(residue, Atom, Prob) {
    .Call(`_Aerith_residue_peak_calculator_DIY`, residue, Atom, Prob)
}

#' @title Precursor Peak Calculator with User-Defined Isotopic Distribution
#' @description This function calculates the isotopic distribution of a given amino acid string with a user-defined isotopic distribution and returns a DataFrame containing the mass and probability of each isotope.
#' @param AAstr A string representing the amino acid sequence.
#' @param Atom A string representing the isotope ("C13", "N15", "H2", "O18", "S34").
#' @param Prob A double representing the abundance of the specified isotope (0.0 to 1.0).
#' @return A DataFrame with two columns: "Mass" containing the mass of each isotope and "Prob" containing the probability of each isotope.
#' @examples
#' # Example usage
#' df <- precursor_peak_calculator_DIY("PEPTIDE", "C13", 0.2)
#' df <- precursor_peak_calculator_DIY("PEPTIDE", "N15", 0.5)
#' @export
precursor_peak_calculator_DIY <- function(AAstr, Atom, Prob) {
    .Call(`_Aerith_precursor_peak_calculator_DIY`, AAstr, Atom, Prob)
}

#' Simple calculator of C H O N P S atom count of peptide
#' @param AAstrs a CharacterVector of peptides
#' @return a dataframe of C H O N P S atom count each row is for one peptide
#' @export
#' @examples
#' df <- calPepAtomCount(c("HKFL","ADCH"))
calPepAtomCount <- function(AAstrs) {
    .Call(`_Aerith_calPepAtomCount`, AAstrs)
}

#' Simple calculator of C H O N P S atom count and mass without isotope of B Y ions
#' @param AAstrs a CharacterVector of peptides
#' @return a list of data.frame of C H O N P S atom count and each data.frame is for one peptide
#' @export
#' @examples
#' peps <- calBYAtomCountAndBaseMass(c("HK~FL","AD!CH","~ILKMV"))
calBYAtomCountAndBaseMass <- function(AAstrs) {
    .Call(`_Aerith_calBYAtomCountAndBaseMass`, AAstrs)
}

#' Simple calculator of peptide precursor mass by binomial NP
#' @param AAstrs a CharacterVector of peptides
#' @param Atom a Character of "C13", "H2", "O18", "N15", or "S34"
#' @param Probs a NumericVector with the same length of AAstr for SIP abundances
#' @return a vector of peptide precursor masses
#' @export
#' @examples
#' masses <- calPepPrecursorMass(c("HKFL", "ADCH"), "C13", c(0.2, 0.3))
calPepPrecursorMass <- function(AAstrs, Atom, Probs) {
    .Call(`_Aerith_calPepPrecursorMass`, AAstrs, Atom, Probs)
}

#' Simple calculator neutron mass by average delta mass of each isotope
#' @param AAstrs a CharacterVector of peptides
#' @param Atom a Character of "C13", "H2", "O18", "N15", or "S34"
#' @param Probs a NumericVector with the same length of AAstr for SIP abundances
#' @return a vector of peptide neutron masses
#' @export
#' @examples
#' masses <- calPepNeutronMass(c("HKFL", "ADCH"), "C13", c(0.2, 0.3))
calPepNeutronMass <- function(AAstrs, Atom, Probs) {
    .Call(`_Aerith_calPepNeutronMass`, AAstrs, Atom, Probs)
}

#' Simple peak calculator of user defined isotopic distribution of one peptide by averagine
#' @param AAstrs a CharacterVector of peptides
#' @param Atom a CharacterVector C13 or N15
#' @param Prob a NumericVector for its abundance
#' @return a list of DataFrames of spectra
#' @examples
#' demoSpectra <- precursor_peak_calculator_DIY_averagine(c("PEPTIDE", "ACDEFGHIK"), "C13", 0.25)
#' demoSpectra[[1]]
#' @export
precursor_peak_calculator_DIY_averagine <- function(AAstrs, Atom, Prob) {
    .Call(`_Aerith_precursor_peak_calculator_DIY_averagine`, AAstrs, Atom, Prob)
}

#' @title BY Ion Peak Calculator with User-Defined Isotopic Distribution
#' @description This function calculates the isotopic distribution of B and Y ions for a given amino acid string with a user-defined isotopic distribution and returns a DataFrame containing the mass, probability, and type of each ion.
#' @param AAstr A string representing the amino acid sequence.
#' @param Atom A string representing the isotope ("C13", "N15", "H2", "O18", "S34").
#' @param Prob A double representing the abundance of the specified isotope (0.0 to 1.0).
#' @return A DataFrame with three columns: "Mass" containing the mass of each ion, "Prob" containing the probability of each ion, and "Kind" indicating whether the ion is a B or Y ion.
#' @examples
#' # Example usage
#' df <- BYion_peak_calculator_DIY("PEPTIDE", "C13", 0.2)
#' df <- BYion_peak_calculator_DIY("PEPTIDE", "N15", 0.5)
#' @export
BYion_peak_calculator_DIY <- function(AAstr, Atom, Prob) {
    .Call(`_Aerith_BYion_peak_calculator_DIY`, AAstr, Atom, Prob)
}

#' readOneScanMS2
#' @param ftFile a ft2 file's full path
#' @param scanNumber the scan at scanNumber
#' @return a list of MS2 scan
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' ft2 <- readOneScanMS2(demo_file, 1633)
#' @export
readOneScanMS2 <- function(ftFile, scanNumber) {
    .Call(`_Aerith_readOneScanMS2`, ftFile, scanNumber)
}

#' readOneScanMS1
#' @param ftFile a ft1 file's full path
#' @param scanNumber the scan at scanNumber
#' @return a list of MS1 scan
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' ft1 <- readOneScanMS1(demo_file, 1588)
#' @export
readOneScanMS1 <- function(ftFile, scanNumber) {
    .Call(`_Aerith_readOneScanMS1`, ftFile, scanNumber)
}

#' read FT file header
#' @param ftFile a ft1 file's full path
#' @return a list of ft file header
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' header <- readFTheader(demo_file)
#' @export
readFTheader <- function(ftFile) {
    .Call(`_Aerith_readFTheader`, ftFile)
}

#' read MS1 scans with scanNumber as index in a range
#' @param ftFile a ft1 file's full path
#' @param startScanNumber read scans starting from this scanNumber
#' @param endScanNumber read scans ending at this scanNumber
#' @return a list of MS1 scans with names of scan number
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' ft1 <- readScansMS1(demo_file, 1398, 1503)
#' @export
readScansMS1 <- function(ftFile, startScanNumber, endScanNumber) {
    .Call(`_Aerith_readScansMS1`, ftFile, startScanNumber, endScanNumber)
}

#' read MS1 scans with scanNumber as index in a vector
#' @param ftFile a ft1 file's full path
#' @param scanNumbersVector a NumericVector of scan numbers
#' @return A named list of MS1 scans with names of scan number. The names of the list correspond to the scan numbers.
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' ft1 <- readScansMS1Vector(demo_file, c(1398, 1503, 1508))
#' @export
readScansMS1Vector <- function(ftFile, scanNumbersVector) {
    .Call(`_Aerith_readScansMS1Vector`, ftFile, scanNumbersVector)
}

#' read MS1 scans with scanNumber as index
#' @param ftFile a ft1 file's full path
#' @return a list of MS1 scans with names of scan number
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' ft1 <- readAllScanMS1(demo_file)
#' @export
readAllScanMS1 <- function(ftFile) {
    .Call(`_Aerith_readAllScanMS1`, ftFile)
}

#' read MS2 scans with scanNumber as index in a range
#' @param ftFile a ft2 file's full path
#' @param startScanNumber read scans starting from this scanNumber
#' @param endScanNumber read scans ending at this scanNumber
#' @return a list of MS2 scans with names of scan number
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' ft2 <- readScansMS2(demo_file, 1350, 1355)
#' @export
readScansMS2 <- function(ftFile, startScanNumber, endScanNumber) {
    .Call(`_Aerith_readScansMS2`, ftFile, startScanNumber, endScanNumber)
}

#' read MS2 scans with scanNumber as index in a vector
#' @param ftFile a ft2 file's full path
#' @param scanNumbersVector read scans starting of these scanNumbers
#' @return a list of MS2 scans with names of scan number
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' ft2 <- readScansMS2Vector(demo_file, c(1350, 1355, 1359))
#' @export
readScansMS2Vector <- function(ftFile, scanNumbersVector) {
    .Call(`_Aerith_readScansMS2Vector`, ftFile, scanNumbersVector)
}

#' read MS2 scans with scanNumber as index
#' @param ftFile a ft2 file's full path
#' @return a list of MS2 scans with names of scan number
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' ft2 <- readAllScanMS2(demo_file)
#' @export
readAllScanMS2 <- function(ftFile) {
    .Call(`_Aerith_readAllScanMS2`, ftFile)
}

#' readSip
#' @param sipFile a .sip file's full path
#' @description Read a single .sip file and convert its peptide-spectrum matches (PSMs) into an R list.
#' @details The reader parses the provided .sip file and returns metadata together with a data.frame of PSM-level attributes.
#' @param sipFile A character vector of length one containing the full path to a .sip file.
#' @return An R list with file-level metadata (`fileName`, `scanType`, `searchName`, `scoringFunction`) and a `PSM` data frame containing scan numbers, charges, masses, scores, ranks, peptides, and protein names.
#' @examples
#' demo_file <- system.file("extdata", "demo.sip", package = "Aerith")
#' re <- readSip(demo_file)
#' head(re$PSM)
#' @export
readSip <- function(sipFile) {
    .Call(`_Aerith_readSip`, sipFile)
}

#' readSips
#' @description Read every `.sip` file found in the provided directory and transform each file's peptide-spectrum matches into an R list entry.
#' @details This function constructs a `sipFileReader` for the supplied folder, loads all `.sip` files, and for each file returns a list containing metadata and a `data.frame` of peptide-spectrum matches (PSMs). The resulting object is an R list whose elements correspond to individual input files.
#' @param workingPath Character vector of length one giving the directory that contains `.sip` files.
#' @return An R list; each element represents one `.sip` file and provides file-level descriptors (`fileName`, `scanType`, `searchName`, `scoringFunction`) together with a `PSM` data frame holding scan numbers, precursor charges, observed/calculated masses, scores, ranks, peptide sequences, and protein assignments.
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' re <- readSips(demo_dir)
#' head(re[[1]]$PSM)
#' @export
readSips <- function(workingPath) {
    .Call(`_Aerith_readSips`, workingPath)
}

#' readFilesScansTopPSMs
#' @description Aggregate the top-ranked peptide-spectrum matches (PSMs) from each scan across all `.sip` files found in a directory.
#' @details This helper constructs an internal `sipFileReader`, loads every `.sip` file located in the supplied path, and extracts the best `topN` PSMs per scan. The result is returned as a single `data.frame` with file identifiers, scan numbers, charge states, mass measurements, scores, peptide assignments, and protein annotations.
#' @param workingPath Character vector of length one giving the directory that contains `.sip` files.
#' @param topN Integer specifying how many top-ranked PSMs per scan to retain for each `.sip` file.
#' @return An R `data.frame` with one row per retained PSM and the columns `fileNames`, `scanNumbers`, `parentCharges`, `measuredParentMasses`, `calculatedParentMasses`, `searchNames`, `scores`, `identifiedPeptides`, `originalPeptides`, and `proteinNames`.
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' re <- readFilesScansTopPSMs(demo_dir, 10)
#' head(re)
#' @export
readFilesScansTopPSMs <- function(workingPath, topN) {
    .Call(`_Aerith_readFilesScansTopPSMs`, workingPath, topN)
}

#' readFilesScansTopPSMsFromOneFT2 read each scan's top PSMs from multiple .sip files of one .FT2 file
#' @param workingPath a full path with .sip files in it
#' @param pattern a regex pattern of the .FT2 file
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @return a dataframe of top N PSMs
#' @examples
#' demo_dir <- system.file("extdata", package = "Aerith")
#' re <- readFilesScansTopPSMsFromOneFT2(demo_dir, ".*demo.*", 3)
#' head(re)
#' @export
readFilesScansTopPSMsFromOneFT2 <- function(workingPath, pattern, topN) {
    .Call(`_Aerith_readFilesScansTopPSMsFromOneFT2`, workingPath, pattern, topN)
}

#' readSpe2Pep
#' @param Spe2PepFile a .Spe2PepFile file's full path
#' @return the PSMs in a dataframe in a list
#' @examples
#' target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' psm <- readSpe2Pep(target_file)
#' psm <- psm$PSM
#' @export
readSpe2Pep <- function(Spe2PepFile) {
    .Call(`_Aerith_readSpe2Pep`, Spe2PepFile)
}

#' readSpe2Peps
#' @param workingPath a full path with .Spe2Pep.txt files in it
#' @return the PSMs dataframes in lists
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' list.files(sip_dir, full.names = TRUE)
#' psm <- readSpe2Peps(sip_dir)
#' psm <- psm[[1]]$PSM
#' @export
readSpe2Peps <- function(workingPath) {
    .Call(`_Aerith_readSpe2Peps`, workingPath)
}

#' readSpe2PepFilesScansTopPSMs read each scan's top PSMs from multiple .Spe2Pep.txt files
#' @param workingPath a full path with .Spe2Pep.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @return the PSMs in a dataframe in a list
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' list.files(sip_dir, full.names = TRUE)
#' psm <- readSpe2PepFilesScansTopPSMs(sip_dir, 3)
#' @export
readSpe2PepFilesScansTopPSMs <- function(workingPath, topN = 5L) {
    .Call(`_Aerith_readSpe2PepFilesScansTopPSMs`, workingPath, topN)
}

#' readSpe2PepFilesScansTopPSMsFromOneFT2 read each scan's top PSMs from multiple .Spe2PepFile.txt files of one .FT2 file
#' @param workingPath a full path with .Spe2PepFile.txt files in it
#' @param pattern a regex pattern of the .FT2 file
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @return a dataframe of top N PSMs
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' list.files(sip_dir, full.names = TRUE)
#' top3 <-  readSpe2PepFilesScansTopPSMsFromOneFT2(sip_dir, ".*X13.*", 3)
#' @export
readSpe2PepFilesScansTopPSMsFromOneFT2 <- function(workingPath, pattern, topN = 5L) {
    .Call(`_Aerith_readSpe2PepFilesScansTopPSMsFromOneFT2`, workingPath, pattern, topN)
}

#' readSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt files of each .FT2 file
#' @param workingPath a full path with .Spe2PepFile.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @return a dataframe of top N PSMs
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' list.files(sip_dir, full.names = TRUE)
#' top3 <-  readSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3)
#' @export
readSpe2PepFilesScansTopPSMsFromEachFT2Parallel <- function(workingPath, topN = 5L) {
    .Call(`_Aerith_readSpe2PepFilesScansTopPSMsFromEachFT2Parallel`, workingPath, topN)
}

#' readSpe2PepFilesScansTopPSMsFromEachFT2TargetAndDecoyParalle read each scan's top PSMs from multiple .Spe2PepFile.txt files of each .FT2 file
#' @param targetPath a full path with target .Spe2PepFile.txt files in it
#' @param decoyPath a full path with decoy .Spe2PepFile.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @return a dataframe of top N PSMs
#' @examples
#' tmp <- tempdir()
#' target_dir <- file.path(tmp, "target")
#' dir.create(target_dir, showWarnings = FALSE)
#' target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' decoy_dir <- file.path(tmp, "decoy")
#' dir.create(decoy_dir, showWarnings = FALSE)
#' decoy_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(decoy_file, file.path(decoy_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
#' list.files(target_dir, full.names = TRUE)
#' list.files(decoy_dir, full.names = TRUE)
#' top3 <- readSpe2PepFilesScansTopPSMsFromEachFT2TargetAndDecoyParallel(target_dir, decoy_dir, 3)
#' @export
readSpe2PepFilesScansTopPSMsFromEachFT2TargetAndDecoyParallel <- function(targetPath, decoyPath, topN = 5L) {
    .Call(`_Aerith_readSpe2PepFilesScansTopPSMsFromEachFT2TargetAndDecoyParallel`, targetPath, decoyPath, topN)
}

#' writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt
#' files of each .FT2 file and write them to one tsv file
#' @param workingPath a full path with .Spe2PepFile.txt files in it
#' @param topN store top N PSMs of each scan of one .FT2 file
#' @param fileName the output path
#' @return nothing but write a tsv of top N PSMs
#' @examples
#' tmp <- tempdir()
#' sip_dir <- file.path(tmp, "sip")
#' dir.create(sip_dir)
#' demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
#' demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
#' file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
#' writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3, file.path(sip_dir, "top3.tsv"))
#' list.files(sip_dir, full.names = TRUE)
#' print(file.info(file.path(sip_dir, "top3.tsv")))
#' @export
writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel <- function(workingPath, topN = 5L, fileName = "a.tsv") {
    invisible(.Call(`_Aerith_writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel`, workingPath, topN, fileName))
}

#' scoreIntensity
#' @param observed this peak is observed or not
#' @param realIntensity real intensity in MS2 scan
#' @param expectedIntensity expected intensity
#' @param Atom "C13" or "N15"
#' @param Prob its SIP abundance (0.0~1.0)
#' @return a score of this intensity match
#' @examples
#' scoreIntensity(TRUE, 1200.0, 1180.0, "C13", 0.02)
#' @export
scoreIntensity <- function(observed, realIntensity, expectedIntensity, Atom, Prob) {
    .Call(`_Aerith_scoreIntensity`, observed, realIntensity, expectedIntensity, Atom, Prob)
}

#' scoreIntensityByCrossEntropy
#' @param expectedIntensity expected intensityreal
#' @param observedIntensity observed intensity in MS2 scan
#' @return numeric, a score of this intensity match
#' @examples
#' scoreIntensityByCE(c(10.0, 20.0, 30.0), c(9.5, 21.0, 28.0))
#' @export
scoreIntensityByCE <- function(expectedIntensity, observedIntensity) {
    .Call(`_Aerith_scoreIntensityByCE`, expectedIntensity, observedIntensity)
}

#' scorePSM
#' @param realMZ mz vector in MS2 scan
#' @param realIntensity intensity vector in MS2 scan
#' @param realCharge charge vector in MS2 scan
#' @param parentCharge int parent charge of MS2 scan
#' @param pepSeq a string of peptide
#' @param Atom "C13" or "N15"
#' @param Prob its SIP abundance (0.0~1.0)
#' @return a score of this PSM
#' @examples
#' demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
#' scan1 <- readOneScanMS2(ftFile = demo_file, 107728)
#' score <- scorePSM(scan1$peaks$mz,
#'         scan1$peaks$intensity, scan1$peaks$charge, 2,
#'         "[HSQVFSTAEDNQSAVTIHVLQGER]", "C13", 0.0107)
#' @export
scorePSM <- function(realMZ, realIntensity, realCharge, parentCharge, pepSeq, Atom, Prob) {
    .Call(`_Aerith_scorePSM`, realMZ, realIntensity, realCharge, parentCharge, pepSeq, Atom, Prob)
}

#' annotatePSM
#' @param realMZ mz vector in MS2 scan
#' @param realIntensity intensity vector in MS2 scan
#' @param realCharge charge vector in MS2 scan
#' @param pepSeq a string of peptide
#' @param charges charges of product ions in consideration
#' @param Atom "C13" or "N15"
#' @param Prob its SIP abundance (0.0~1.0)
#' @param isoCenter isolation window center, set it 0 as default if not remove peaks in isolation window
#' @param isoWidth isolation window width, set it 0 as default if not remove peaks in isolation window
#' @param calScores, FALSE as default, calculate WDP MVH Xcor scores or not
#' @return a List about matched peaks information of this PSM
#' @examples
#' demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
#' scan1 <- readOneScanMS2(ftFile = demo_file, 107728)
#' anno <- annotatePSM(
#'   scan1$peaks$mz, scan1$peaks$intensity,
#'   scan1$peaks$charge,
#'   "HSQVFSTAEDNQSAVTIHVLQGER", 1:2, "C13",
#'   0.0107, 886.65, 4.0, TRUE
#' )
#' @export
annotatePSM <- function(realMZ, realIntensity, realCharge, pepSeq, charges, Atom, Prob, isoCenter = 0, isoWidth = 0, calScores = FALSE) {
    .Call(`_Aerith_annotatePSM`, realMZ, realIntensity, realCharge, pepSeq, charges, Atom, Prob, isoCenter, isoWidth, calScores)
}

#' scorePSMsimple Score a PSM without isotopic envelope shape modeling
#' @param realMZ mz vector in MS2 scan
#' @param realIntensity intensity vector in MS2 scan
#' @param realCharge charge vector in MS2 scan
#' @param parentCharge precursor charge, 2 for example
#' @param pepSeq a string of peptide
#' @param Atom "C13" or "N15"
#' @param Prob its SIP abundance (0.0~1.0)
#' @return a score of this PSM
#' @examples
#' demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
#' scan1 <- readOneScanMS2(ftFile = demo_file, scanNumber = 107728)
#' score <- scorePSMsimple(
#'   scan1$peaks$mz,
#'   scan1$peaks$intensity,
#'   scan1$peaks$charge,
#'   2,
#'   "[HSQVFSTAEDNQSAVTIHVLQGER]",
#'   "C13",
#'   0.0107
#' )
#' @export
scorePSMsimple <- function(realMZ, realIntensity, realCharge, parentCharge, pepSeq, Atom, Prob) {
    .Call(`_Aerith_scorePSMsimple`, realMZ, realIntensity, realCharge, parentCharge, pepSeq, Atom, Prob)
}

#' rankify numeric vector via ftFileWriter
#' @param a A numeric vector whose values will be rank-transformed.
#' @return A numeric vector containing the ranks of the input values.
#' @examples
#' demo_vec <- c(12.5, 3.2, 7.7, 3.2)
#' rankyfify(demo_vec)
#' @export
rankyfify <- function(a) {
    .Call(`_Aerith_rankyfify`, a)
}

#' denoise one MS2 scan has charge
#' @param scanList a list of one MS2 scan has charge
#' @param window a float of mz window size for denoise
#' @param step a float of mz step for denoise
#' @param threshold a float of top N threshold for denoise
#' @return a denoised MS2 scan has charge
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' ft2 <- readAllScanMS2(demo_file)
#' plot(getRealScanFromList(ft2[["1346"]]))
#' ms2 <- denoiseOneMS2ScanHasCharge(ft2[["1346"]], 100, 10, 5)
#' plot(getRealScanFromList(ms2))
#' @export
denoiseOneMS2ScanHasCharge <- function(scanList, window, step, threshold) {
    .Call(`_Aerith_denoiseOneMS2ScanHasCharge`, scanList, window, step, threshold)
}

#' write all MS1 scans has charge
#' @param header a list of FT file header
#' @param scansList a list of scans for output
#' @param ftFile a ft1 file's output path
#' @return TRUE if the file was written successfully, FALSE otherwise
#' @examples
#' rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
#' demo_file <- tempfile(fileext = ".FT1")
#' writeLines(readRDS(rds), demo_file)
#' header <- readFTheader(demo_file)
#' ft1 <- readAllScanMS1(demo_file)
#' tmp <- tempdir()
#' writeAllScanMS1(header, ft1[1:10], file.path(tmp, "demo10.FT1"))
#' list.files(tmp, pattern = "demo10.FT1", full.names = TRUE)
#' @export
writeAllScanMS1 <- function(header, scansList, ftFile) {
    .Call(`_Aerith_writeAllScanMS1`, header, scansList, ftFile)
}

#' write all MS2 scans has charge
#' @param header a list of FT file header
#' @param scansList a list of scans for output
#' @param ftFile a ft2 file's output path
#' @return TRUE if the file was written successfully, FALSE otherwise
#' @examples
#' demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
#' header <- readFTheader(demo_file)
#' ft2 <- readAllScanMS2(demo_file)
#' tmp <- tempdir()
#' writeAllScanMS2(header,ft2[1:10],file.path(tmp, "demo10.FT2"))
#' list.files(tmp, pattern = "demo10.FT2", full.names = TRUE)
#' @export
writeAllScanMS2 <- function(header, scansList, ftFile) {
    .Call(`_Aerith_writeAllScanMS2`, header, scansList, ftFile)
}

