% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkerCategorization.r
\name{biomarkerCategorization}
\alias{biomarkerCategorization}
\title{biomarker categrorization}
\usage{
biomarkerCategorization(studies, afunction, B = 10, DEindex = NULL,
  fdr = NULL, silence = FALSE)
}
\arguments{
\item{studies}{a list of K studies. 
Each element (kth study) of the list is another list 
consisting gene expression matrix and and label information.}

\item{afunction}{A function for DE analysis. 
Options can be function_limma or function_edgeR. 
Default option is function_limma. 
However, use could define their own function. 
The input of afunction should be list(data, label) 
which is consistent with one element of the studies list/argument. 
The return of afunction should be 
list(pvalue=apvalue, effectSize=aeffectsize)}

\item{B}{number of permutation should be used. B=1000 is suggested.}

\item{DEindex}{If NULL, 
BH method will be applied to p-values and FDR 0.05 will be used. 
User could specify a logical vector as DEindex.}

\item{fdr}{Default is 0.05. 
The co-membership matrix calculation will base on 
genes with this specified fdr.}

\item{silence}{If TRUE, will print out the bootstrapping procedure.}
}
\value{
A list consisting of biomarker categrorization result.
\item{varibility}{Varibility index for all genes}
\item{dissimilarity}{Dissimilarity matrix of genes of DEindex==TRUE}
\item{DEindex}{DEindex for Dissimilarity}
}
\description{
biomarker categrorization
}
\details{
biomarker categrorization via boostrap AW weight.
}
\examples{
N0 = 10
G <- 1000
GDEp <- 50
GDEn <- 50
K = 4

studies <- NULL
set.seed(15213)
for(k in seq_len(K)){
    astudy <- matrix(rnorm(N0*2*G),nrow=G,ncol=N0*2)
    ControlLabel <- seq_len(N0)
    caseLabel <- (N0 + 1):(2*N0)

    astudy[1:GDEp,caseLabel] <- astudy[1:GDEp,caseLabel] + 2
    astudy[1:GDEp + GDEn,caseLabel] <- astudy[1:GDEp + GDEn,caseLabel] - 2

    alabel = c(rep(0,length(ControlLabel)),rep(1,length(caseLabel)))

    studies[[k]] <- list(data=astudy, label=alabel)
}


result <- biomarkerCategorization(studies,function_limma,B=100,DEindex=NULL)
sum(result$DEindex)
head(result$varibility)
print(result$dissimilarity[1:4,1:4])
}
\author{
Zhiguang Huo
}
