% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_calcAUC.R
\name{AUCell_calcAUC}
\alias{AUCell_calcAUC}
\alias{AUCell_calcAUC,list-method}
\alias{AUCell_calcAUC,character-method}
\alias{AUCell_calcAUC,GeneSet-method}
\alias{AUCell_calcAUC,GeneSetCollection-method}
\title{Calculate AUC}
\usage{
AUCell_calcAUC(
  geneSets,
  rankings,
  nCores = 1,
  normAUC = TRUE,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  verbose = TRUE
)

\S4method{AUCell_calcAUC}{list}(
  geneSets,
  rankings,
  nCores = 1,
  normAUC = TRUE,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  verbose = TRUE
)

\S4method{AUCell_calcAUC}{character}(
  geneSets,
  rankings,
  nCores = 1,
  normAUC = TRUE,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  verbose = TRUE
)

\S4method{AUCell_calcAUC}{GeneSet}(
  geneSets,
  rankings,
  nCores = 1,
  normAUC = TRUE,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  verbose = TRUE
)

\S4method{AUCell_calcAUC}{GeneSetCollection}(
  geneSets,
  rankings,
  nCores = 1,
  normAUC = TRUE,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  verbose = TRUE
)
}
\arguments{
\item{geneSets}{List of gene-sets (or signatures) to test in the cells.
The gene-sets should be provided as \code{\link{GeneSet}},
\code{\link{GeneSetCollection}} or character list (see examples).}

\item{rankings}{'Rankings' created for this dataset with
\code{\link{AUCell_buildRankings}}.}

\item{nCores}{Number of cores to use for computation.}

\item{normAUC}{Wether to normalize the maximum possible AUC to 1 (Default: TRUE).}

\item{aucMaxRank}{Threshold to calculate the AUC (see 'details' section)}

\item{verbose}{Should the function show progress messages? (TRUE / FALSE)}
}
\value{
Matrix with the AUC values (gene-sets as rows, cells as columns).
}
\description{
Calculates the 'AUC' for each gene-set in each cell.
}
\details{
In a simplified way, the AUC value represents the fraction of genes,
 within the top X genes in the ranking, that are included in the signature.
The parameter 'aucMaxRank' allows to modify the number of genes
(maximum ranking) that is used to perform this computation.
By default, it is set to 5\% of the total number of genes in the rankings.
Common values may range from 1 to 20\%.
}
\examples{
# This example is run using a fake expression matrix.
# Therefore, the output will be meaningless.

############# Fake expression matrix #############
set.seed(123)
exprMatrix <- matrix(data=sample(c(rep(0, 5000), sample(1:3, 5000, replace=TRUE))),
                     nrow=20, 
                     dimnames=list(paste("Gene", 1:20, sep=""), 
                                   paste("Cell", 1:500, sep="")))
##################################################

######### Previous step in the workflow ##########
# Step 1.
cells_rankings <- AUCell_buildRankings(exprMatrix)
##################################################

############## Step 2: Calculate AUC #############

# In this example we use two gene sets: 10 and 5 random genes
# (see other formatting examples at the end)
fewGenes <- sample(rownames(exprMatrix), 10)
otherGenes <- sample(rownames(exprMatrix), 5)

geneSets <- list(geneSet1=fewGenes,
                 geneSet2=otherGenes)
geneSets

# Calculate AUC with the rankings from Step 1.
# To be able to run this fake example (which contain only 20 genes),
# we use aucMaxRank=5 (top 25\% of the genes in the ranking)
cells_AUC <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5, nCores=1)

# Format of the output:
cells_AUC

# To subset & access the AUC slot (as matrix):
cells_AUC[1:2,]
cells_AUC[,3:4]
getAUC(cells_AUC)[,1:5]


# These methods are also available:
dim(cells_AUC)
nrow(cells_AUC)
ncol(cells_AUC)
colnames(cells_AUC)[1:4]
rownames(cells_AUC)

#########################################################
# Alternatives for the input of gene sets:

# a) Character vector (i.e. only one gene-set)
# It will take the default name 'geneSet'
fewGenes
test <- AUCell_calcAUC(fewGenes, cells_rankings, aucMaxRank=5)

# b) List
geneSets <- list(geneSet1=fewGenes,
                 geneSet2=otherGenes)
geneSets
test <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5)

# c) GeneSet object (from GSEABase)
library(GSEABase)
geneSetOne <- GeneSet(fewGenes, setName="geneSetOne")
geneSetOne
test <- AUCell_calcAUC(geneSetOne, cells_rankings, aucMaxRank=5)


# d) GeneSetCollection object (from GSEABase)
geneSetTwo <- GeneSet(otherGenes, setName="geneSetTwo")
geneSets <- GeneSetCollection(geneSetOne, geneSetTwo)
geneSets
test <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5)
}
\seealso{
Previous step in the workflow: \code{\link{AUCell_buildRankings}}.
Next step in the workflow: \code{\link{AUCell_exploreThresholds}}.

See the package vignette for examples and more details:
\code{vignette("AUCell")}
}
