% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotES.R
\name{plotES}
\alias{plotES}
\title{Plot enrichment score for one transcription factor}
\usage{
plotES(
  TFEAresults,
  TF,
  outfolder = ".",
  xlab = "rank",
  ylab = "Enrichment",
  resolution = 500L,
  device = "pdf",
  ...
)
}
\arguments{
\item{TFEAresults}{A \link{TFEAresults} object. Output of \link{TFEA}.}

\item{TF}{A character vector. The transcription factor names.}

\item{outfolder}{character(1). Output file path.}

\item{xlab, ylab}{character string giving label for x-axis/y-axis.}

\item{resolution}{integer(1). The number of bars plotted in the bottom of
figure to show the density of occurrence of events.}

\item{device}{Device to use. Can be one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).}

\item{...}{parameter passed to ggsave.}
}
\value{
NULL if outfolder is set or ggplot object.
}
\description{
Plot GSEA style enrichment score curve.
}
\examples{
res <- system.file("extdata", "res.rds", package="ATACseqTFEA")
res <- readRDS(res)
g <- plotES(res, TF="KLF9", outfolder=NA)
g
}
