% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandBindingSites.R
\name{expandBindingSites}
\alias{expandBindingSites}
\title{Prepare the genomic ranges for proximal and distal regions for counting}
\usage{
expandBindingSites(bindingSites, proximal = 40L, distal = proximal, gap = 10L)
}
\arguments{
\item{bindingSites}{A object of
\link[GenomicRanges:GRanges-class]{GenomicRanges} indicates
candidate binding sites. The \link{prepareBindingSites} function
is a helper function to generate the binding sites.
Users can also use other software for example fimo to generate the list.}

\item{proximal, distal}{numeric(1) or integer(1).
bases for open region from binding sites (proximal) and
extended region for background (distal)
of the binding region for aggregate ATAC-seq footprint.}

\item{gap}{numeric(1) or integer(1). bases for gaps among binding sites,
proximal, and distal. default is 10L.}
}
\value{
an \link[GenomicRanges:GRangesList-class]{GRangesList} object with
elements bindingSitesWithGap, bindingSitesWithProximal,
bindingSitesWithProximalAndGap, and bindingSitesWithDistal
for \link{count5ends}
}
\description{
Create multiple GRanges objects for downstream counting.
The GRanges objects including
bindingSitesWithGap: bindingSites with gaps and in both ends,
bindingSitesWithProximal: bindingSites with gaps and proximal region
in both ends,
bindingSitesWithProximalAndGap: bindingSites with gaps, and then proximal
and gaps in both ends,
and bindingSitesWithDistal: bindingSites with gaps, proximal, gaps and
distal regions.
}
\examples{
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
bs <- expandBindingSites(bindingSites)
length(bs)
names(bs)
lengths(bs)
}
\author{
Jianhong Ou
}
