% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doTFEA.R
\name{doTFEA}
\alias{doTFEA}
\title{Transcription factor enrichment analysis}
\usage{
doTFEA(se, ...)
}
\arguments{
\item{se}{An \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
object. Filtered outputs of \link{DBscore}.}

\item{...}{Not used.}
}
\value{
A \link{TFEAresults} object.
}
\description{
Transcription factor enrichment analysis for the filtered
 output of \link{DBscore}
}
\examples{
bamExp <- system.file("extdata",
                      c("KD.shift.rep1.bam",
                        "KD.shift.rep2.bam"),
                      package="ATACseqTFEA")
bamCtl <- system.file("extdata",
                      c("WT.shift.rep1.bam",
                        "WT.shift.rep2.bam"),
                      package="ATACseqTFEA")
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
## get the count regions
bsEx <- expandBindingSites(bindingSites)
## count reads by 5'ends
res <- count5ends(c(bamExp, bamCtl),
                  positive=0L, negative=0L,
                  bindingSites=bindingSites,
                  bindingSitesWithGap=bsEx$bindingSitesWithGap,
                  bindingSitesWithProximal=bsEx$bindingSitesWithProximal,
                  bindingSitesWithProximalAndGap=
                      bsEx$bindingSitesWithProximalAndGap,
                  bindingSitesWithDistal=bsEx$bindingSitesWithDistal)
## filter 0 counts in proximal
se <- eventsFilter(res, proximalRegion>0)
## normalize counts by width of count region
se <- countsNormalization(se, proximal=40, distal=40)
## get the weighted binding scores
se <- getWeightedBindingScore(se)
design <- cbind(CTL=1, EXPvsCTL=c(1, 1, 0, 0))
rownames(design) <- colnames(se)
counts <- DBscore(se, design=design, coef="EXPvsCTL")
doTFEA(counts)
}
\author{
Jianhong Ou
}
