% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countsNormalization.R
\name{countsNormalization}
\alias{countsNormalization}
\title{Normalize counts by width of count region}
\usage{
countsNormalization(se, proximal, distal)
}
\arguments{
\item{se}{An \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
object. Outputs of \link{count5ends} or \link{eventsFilter}.}

\item{proximal, distal}{numeric(1) or integer(1).
bases for open region from binding sites (proximal) and
extended region for background (distal)
of the binding region for aggregate ATAC-seq footprint.}
}
\value{
A RangedSummarizedExperiment object with assays of
count matrix with bindingSites, proximalRegion and distalRegion as
column names and bindingSites GRanges object as rowRanges.
}
\description{
Do normalization by width for counts in binding sites, proximal
 and distal regions.
}
\examples{
bam <- system.file("extdata",
                   "KD.shift.rep1.bam",
                   package="ATACseqTFEA")
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
## get the count regions
bsEx <- expandBindingSites(bindingSites)
## count reads by 5'ends
res <- count5ends(bam, positive=0L, negative=0L,
                  bindingSites=bindingSites,
                  bindingSitesWithGap=bsEx$bindingSitesWithGap,
                  bindingSitesWithProximal=bsEx$bindingSitesWithProximal,
                  bindingSitesWithProximalAndGap=
                      bsEx$bindingSitesWithProximalAndGap,
                  bindingSitesWithDistal=bsEx$bindingSitesWithDistal)
## filter 0 counts in proximal
se <- eventsFilter(res, proximalRegion>0)
## normalize counts by width of count region
countsNormalization(se, proximal=40, distal=40)
}
\author{
Jianhong Ou
}
