% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count5ends.R
\name{count5ends}
\alias{count5ends}
\title{Prepare counts matrix for enrichment analysis}
\usage{
count5ends(
  bam,
  index = bam,
  yieldSize = 1e+05,
  positive = 4L,
  negative = 5L,
  bindingSites,
  bindingSitesWithGap,
  bindingSitesWithProximal,
  bindingSitesWithProximalAndGap,
  bindingSitesWithDistal
)
}
\arguments{
\item{bam}{A character vector indicates the file names of the
bams or an object of \link[Rsamtools:BamFile]{BamFile}.}

\item{index}{The names of the index file of the 'BAM' file
being processed; This is given without the '.bai' extension.}

\item{yieldSize}{Number of records to yield each time the file is read.
See \link[Rsamtools:BamFile]{BamFile} for details.}

\item{positive, negative}{integer(1). the size to be shift for
positive/negative strand.
If the bam file is 5'end shifed files, please set the parameter to 0.}

\item{bindingSites}{A object of
\link[GenomicRanges:GRanges-class]{GenomicRanges} indicates
candidate binding sites. The \link{prepareBindingSites} function
is a helper function to generate the binding sites.
Users can also use other software for example fimo to generate the list.}

\item{bindingSitesWithGap}{bindingSites with gaps and in both ends,}

\item{bindingSitesWithProximal}{bindingSites with gaps and proximal region
in both ends,}

\item{bindingSitesWithProximalAndGap}{bindingSites with gaps, and then
proximal and gaps in both ends,}

\item{bindingSitesWithDistal}{bindingSites with gap, proximal, gap and
distal regions.}
}
\value{
A RangedSummarizedExperiment object with assays of
count matrix with bindingSites, proximalRegion and distalRegion as
column names and bindingSites GRanges object as rowRanges.
}
\description{
Prepare the counts matrix by 5'end of reads.
}
\examples{
bam <- system.file("extdata",
                   "KD.shift.rep1.bam",
                   package="ATACseqTFEA")
bsl <- system.file("extdata", "bindingSites.rds",
                   package="ATACseqTFEA")
bindingSites <- readRDS(bsl)
## get the count regions
bsEx <- expandBindingSites(bindingSites)
res <- count5ends(bam, positive=0L, negative=0L,
                  bindingSites=bindingSites,
                  bindingSitesWithGap=bsEx$bindingSitesWithGap,
                  bindingSitesWithProximal=bsEx$bindingSitesWithProximal,
                  bindingSitesWithProximalAndGap=
                      bsEx$bindingSitesWithProximalAndGap,
                  bindingSitesWithDistal=bsEx$bindingSitesWithDistal)
head(res)
}
\author{
Jianhong Ou
}
