% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-TFEAresults.R
\name{getEnrichmentScore}
\alias{getEnrichmentScore}
\alias{getBindingSites}
\alias{getMotifID}
\alias{TFEAresults-methods}
\alias{coerce,TFEAresults,data.frame-method}
\alias{as,TFEAresults,data.frame-method}
\alias{show,TFEAresults-method}
\alias{$,TFEAresults-method}
\alias{$<-,TFEAresults-method}
\alias{[[,TFEAresults,ANY,ANY-method}
\alias{[[<-,TFEAresults,ANY,ANY-method}
\alias{getEnrichmentScore,TFEAresults-method}
\alias{getBindingSites,TFEAresults-method}
\alias{getMotifID,TFEAresults-method}
\title{The methods for \link{TFEAresults-class}}
\usage{
getEnrichmentScore(x)

getBindingSites(x, TF)

getMotifID(x)

\S4method{show}{TFEAresults}(object)

\S4method{$}{TFEAresults}(x, name)

\S4method{$}{TFEAresults}(x, name) <- value

\S4method{[[}{TFEAresults,ANY,ANY}(x, i, j, ..., exact = TRUE)

\S4method{[[}{TFEAresults,ANY,ANY}(x, i, j, ...) <- value

\S4method{getEnrichmentScore}{TFEAresults}(x)

\S4method{getBindingSites}{TFEAresults}(x, TF)

\S4method{getMotifID}{TFEAresults}(x)
}
\arguments{
\item{x}{TFEAresults object.}

\item{TF}{Transcription factor}

\item{object}{an object of TFEAresults}

\item{name}{A literal character string or a name (possibly backtick quoted).}

\item{value}{value to replace.}

\item{i, j}{indices specifying elements to extract or replace.}

\item{\dots}{Named or unnamed arguments to form a signature.}

\item{exact}{see \link[base]{Extract}}
}
\value{
The `getEnrichmentScore` method will return the
 enrichment score matrix.

The `getBindingSites` method will return a GRanges object indicates
 binding sites.

The method `getMotifID` will return A list of positions of
the binding sites for the motifs.
}
\description{
The assessment and replacement methods for
\link{TFEAresults-class}
}
\examples{
res <- readRDS(system.file("extdata", "res.rds", package="ATACseqTFEA"))
as(res, "data.frame")
res
head(res$resultsTable)
head(res[["resultsTable"]])
head(getEnrichmentScore(res))
}
\concept{TFEAresults}
