% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{TFEAresults-class}
\alias{TFEAresults-class}
\alias{TFEAresults}
\title{Class \code{"TFEAresults"}}
\usage{
TFEAresults(...)
}
\arguments{
\item{\dots}{Each argument in \dots becomes an slot in the new
\code{"TFEAresults"}-class.}
}
\value{
A TFEAresults object.
}
\description{
An object of class \code{"TFEAresults"}
  represents the results of \link{TFEA}.
}
\section{Slots}{

\describe{
\item{\code{enrichmentScore}}{\code{"numeric \link[Matrix]{Matrix}"}, specify the
enrichment score for each transcription factor (TF). Every row represents
a TF. The columns represents the accumulated enrichment score for that rank.}

\item{\code{bindingSites}}{\code{\link[GenomicRanges:GRanges-class]{GenomicRanges}}
object. It is keep same length and order as the columns in enrichmentScore.}

\item{\code{motifID}}{\code{"list"}. The ranks of binding sites for each TF.}

\item{\code{resultsTable}}{\code{"data.frame"}. The data frame contains the
summarized enrichment score, the p-value, and adjuct p-value for each TF.}
}}

\examples{
res <- readRDS(system.file("extdata", "res.rds", package="ATACseqTFEA"))
res
}
