% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoplot.R
\name{ESvolcanoplot}
\alias{ESvolcanoplot}
\title{Plot enrichment score for one transcription factor}
\usage{
ESvolcanoplot(
  TFEAresults,
  xlab = "Enrichment Score",
  ylab = "-log10(p value)",
  TFnameToShow = 20,
  significantCutoff = 0.05,
  col = c("red", "blue", "gray"),
  ...
)
}
\arguments{
\item{TFEAresults}{A \link{TFEAresults} object. Output of \link{TFEA}.}

\item{xlab, ylab}{character string giving label for x-axis/y-axis.}

\item{TFnameToShow}{Transcription factor names to be drawn.}

\item{significantCutoff}{Cutoff value for significant.}

\item{col}{Color sets for the points.}

\item{...}{parameter passed to pdf.}
}
\value{
ggplot object.
}
\description{
Plot GSEA style enrichment score curve.
}
\examples{
res <- system.file("extdata", "res.rds", package="ATACseqTFEA")
res <- readRDS(res)
ESvolcanoplot(TFEAresults=res)
}
