% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bamQC.R
\name{bamQC}
\alias{bamQC}
\title{Mapping quality control}
\usage{
bamQC(
  bamfile,
  index = bamfile,
  mitochondria = "chrM",
  outPath = sub(".bam", ".clean.bam", basename(bamfile)),
  doubleCheckDup = FALSE
)
}
\arguments{
\item{bamfile}{character(1). File name of bam.}

\item{index}{character(1). File name of index file.}

\item{mitochondria}{character(1). Sequence name of mitochondria.}

\item{outPath}{character(1). File name of cleaned bam.}

\item{doubleCheckDup}{logical(1). Double check duplicates or not if there is no tags for that.}
}
\value{
A list of quality summary.
}
\description{
Check the mapping rate, PCR duplication rate,
and mitochondria reads contamination.
}
\examples{
bamfile <- system.file("extdata", "GL1.bam", package="ATACseqQC")
bamQC(bamfile, outPath=NULL)
}
\author{
Jianhong Ou
}
