% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_signs.R
\name{remove_signs}
\alias{remove_signs}
\title{Remove signs including too few or too many genes.}
\usage{
remove_signs(sce = NULL, min_ngenes = 2, max_ngenes = 1000)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{min_ngenes}{Minimum number of genes, which must be greater than one.}

\item{max_ngenes}{Maximum number of genes, which must be greater than one.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function removes signs including too few or too many genes.
}
\examples{
data(pbmc_eg)
data(human_GO_eg)
pbmcs <- list(GO = pbmc_eg)
S4Vectors::metadata(pbmcs$GO) <- list(sign = human_GO_eg[["BP"]])
pbmcs$GO <- remove_signs(sce = pbmcs$GO, min_ngenes = 2, max_ngenes = 1000)
# The results are stored in `metadata(pbmcs$GO)$sign`.

}
