% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_marker_signs.R
\name{compute_sepI_clusters}
\alias{compute_sepI_clusters}
\title{Compute separation indices of sign scores for given two clusters.}
\usage{
compute_sepI_clusters(
  sce = NULL,
  labels = NULL,
  nrand_samples = NULL,
  ident_1 = NULL,
  ident_2 = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{labels}{A vector of labels of all the samples.}

\item{nrand_samples}{An integer for the number of samples used for
random sampling, which samples at least one sample per cluster.}

\item{ident_1}{Label names identifying cluster numbers,
e.g., ident_1 = 1, ident_1 = c(1, 3).}

\item{ident_2}{Label names identifying cluster numbers,
e.g., ident_2 = 2, ident_2 = c(2, 4).}
}
\value{
A SingleCellExperiment object.
}
\description{
This function computes separation indices of sign scores for given two
  clusters.
}
\examples{
data(pbmcs_eg)
labels <- SummarizedExperiment::colData(pbmcs_eg$GO)$seurat_clusters
pbmcs_eg$GO <- compute_sepI_clusters(sce = pbmcs_eg$GO, labels = labels,
                                     nrand_samples = 10, ident_1 = 1,
                                     ident_2 = c(0, 2))
# The results are stored in `metadata(pbmcs_eg$GO)$marker_signs`.

}
