% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runassignGFRN.R
\name{runassignGFRN}
\alias{runassignGFRN}
\title{Run optimized single pathway ASSIGN}
\usage{
runassignGFRN(
  indata,
  run = c("akt", "bad", "egfr", "her2", "igf1r", "krasgv", "raf"),
  optimized_geneList = NULL,
  use_seed = 1234,
  sigma_sZero = 0.05,
  sigma_sNonZero = 0.5,
  S_zeroPrior = FALSE,
  iter = 1e+05,
  burn_in = 50000,
  exclude_common_genes = FALSE,
  adaptive_S = TRUE,
  ECM = FALSE
)
}
\arguments{
\item{indata}{The list of data frames from ComBat.step2}

\item{run}{specifies the pathways to predict. The default list will
cause all eight pathways to be run in serial. Specify a pathway ("akt",
"bad", "egfr", etc.) or list of pathways to run those pathways only.}

\item{optimized_geneList}{a list of custom optimized gene lists for the gfrn
pathways either created manually or output by optimizeGFRN}

\item{use_seed}{Set the seed before running ASSIGN. This will make the result
consistent between runs. The default is 1234. Set use_seed as FALSE to not
set a seed.}

\item{sigma_sZero}{Each element of the signature matrix (S) is modeled by a
spike-and-slab mixture distribution. Sigma_sZero is the variance of the
spike normal distribution. The default is 0.05.}

\item{sigma_sNonZero}{Each element of the signature matrix (S) is modeled by
a spike-and-slab mixture distribution. Sigma_sNonZero is the variance of the
slab normal distribution. The default is 0.5.}

\item{S_zeroPrior}{Logicals. If TRUE, the prior distribution of signature
follows a normal distribution with mean zero. The default is FALSE.}

\item{iter}{The number of iterations in the MCMC. The default is 100000.}

\item{burn_in}{The number of burn-in iterations. These iterations are
discarded when computing the posterior means of the model parameters. The
default is 50000.}

\item{exclude_common_genes}{Remove commonly differentially expressed genes
for overexpression signatures. The default is FALSE.}

\item{adaptive_S}{Logical. If TRUE, the model adapts the signatures (S) of
genomic measures for the test samples. The default for GFRN analysis is TRUE.}

\item{ECM}{Logicals. If TRUE, ECM algorithm, rather than Gibbs sampling, is
applied to approximate the model parameters. The default is FALSE.}
}
\value{
Data is output to the current working directory in a results
directory.
}
\description{
This function runs eight ASSIGN runs based on the pathway optimizations
from the paper. You can run all eight pathways in serial, or call this
function and specify the run parameter to run a specific pathway.
Some ASSIGN parameters can be customized using this function. The default
values were used in the analysis for the paper.
}
\examples{
\dontrun{
testData <- read.table(paste0("https://drive.google.com/uc?authuser=0&",
                              "id=1mJICN4z_aCeh4JuPzNfm8GR_lkJOhWFr",
                              "&export=download"),
                       sep='\t', row.names=1, header=1)
combat.data <- ComBat.step2(testData, pcaPlots = TRUE)
runassignGFRN(combat.data)
}

}
