% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastASSET.R
\name{fast_asset}
\alias{fast_asset}
\title{Fast ASSET using pre-screening}
\usage{
fast_asset(
  snp,
  traits.lab,
  beta.hat,
  sigma.hat,
  Neff,
  cor,
  block,
  scr_pthr = 0.05
)
}
\arguments{
\item{snp}{A character string giving the SNP name to be analyzed. No default.}

\item{traits.lab}{A character vector giving the names/identifiers of the k studies/traits being analyzed. The order of this vector must match the columns of beta.hat and sigma.hat No default.}

\item{beta.hat}{A numeric vector of length k giving the coefficients obtained from the analysis of that SNP across the k studies/traits. No default.}

\item{sigma.hat}{A vector of same dimension as beta.hat, giving the corresponding standard errors. No default.}

\item{Neff}{A numeric vector of same dimension as beta.hat, giving the effective sample size of each study. For continuous traits, the effective sample size is the total sample size; for binary traits, the effective sample size is Ncase*Ncontrol/(Ncase+Ncontrol).}

\item{cor}{A matrix of dimension k by k storing the correlation of z-statistics under the null hypothesis. It can be estimated using LD score regression (https://github.com/bulik/ldsc). For example, element \code{(j,k)} is the LD score regression intercept between traits \code{j} and {k}. Diagonal elements are equal to 1. Set to identity matrix if different studies do not have overlapping samples.}

\item{block}{A list of character vectors. Each element is a vector of study/trait names that fall into the same correlation block based on \code{cor}. Studies from different blocks are treated as independent. Studies that are not in \code{block} are treated as independent from other studies.}

\item{scr_pthr}{P-value threshold for pre-screening. Only traits with p-value < scr_pthr are retained. Default to 0.05.}
}
\value{
A list of the same format as the output of \code{h.traits}.
}
\description{
This function implements a fast version of ASSET for analysis of a large number of traits. It accelerates the computation by restricting subset search among the traits with suggestive level of associations. The traits are selected by a liberal p-value threshold. The input is GWAS summary statistics for one SNP. See details for more information.
}
\details{
The standard ASSET (\code{h.traits}) which searches through all subsets can be computationally intractable for analyzing a large number of traits. \code{fast_asset} reduces the computational burden by the following procedure: (1) De-correlate the z-statistics associated with different traits using the correlation matrix (\code{cor}); (2) select the set of traits using a liberal threshold (p<0.05 by default) of the de-correlated z-statistics; (3) adjust the de-correlated z-statistics for the pre-selection independently across different traits; (4) re-introduce the correlation using the matrix \code{cor} and supply the adjusted statistics to standard ASSET.
}
\examples{
data("ex_fast_asset", package="ASSET")
block <- create_blocks(ldscintmat)
test <- fast_asset(snp=SNP, traits.lab=traits, beta.hat=betahat, sigma.hat=SE
                , Neff=Neff, cor=ldscintmat, block=block, scr_pthr=0.05)
}
\references{
Guanghao Qi, Surya Chhetri, Elizaveta Naydanova, Debashree Ray, Diptavo Dutta, Alexis Battle, Samsiddhi Bhattacharjee and Nilanjan Chatterjee. "Genome-wide Multi-trait Analysis Across 116 Studies Identifies Complex Patterns of Pleiotropy and Unique Trait-Specific Loci". In preparation (2021).
}
