% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_on_quantification.R
\name{oplsda}
\alias{oplsda}
\title{Orthogonal projections to latent structures discriminant analysis (OPLS-DA)
on a \code{\link{SummarizedExperiment}} object}
\usage{
oplsda(
  analysis_data,
  condition,
  cross.val = 1,
  thres.VIP = 1,
  type.data = "quantifications",
  seed = 12345,
  ...
)
}
\arguments{
\item{analysis_data}{A \code{\link{SummarizedExperiment}} object obtained
with the \code{\link{formatForAnalysis}} function.}

\item{condition}{The name of the design variable (two level factor)
specifying the response to be explained.}

\item{cross.val}{Number of cross validation folds.}

\item{thres.VIP}{A number specifying the VIP threshold used to identify
influential variables.}

\item{type.data}{Type of data used for the analyses (\emph{e.g.,}
\code{"quantifications"}, \code{"buckets"}...). Default to
\code{"quantifications"}.}

\item{seed}{Random seed to control randomness of cross validation folds.}

\item{...}{Further arguments to be passed to the function
\code{\link{opls}} for specifying the parameters of the algorithm, if
necessary.}
}
\value{
A S4 object of class \linkS4class{AnalysisResults} containing OPLS-DA
results.
}
\description{
Perform an OPLS-DA with the function of the \code{\link{ropls}} package on a
\code{\link{SummarizedExperiment}} object obtained with the
\code{\link{formatForAnalysis}} function
}
\examples{
# Import quantification results
if (require("ASICSdata", quietly = TRUE)) {
  quantif_path <- system.file("extdata", "results_ASICS.txt",
                              package = "ASICSdata")
  quantification <- read.table(quantif_path, header = TRUE, row.names = 1)

  # Import design
  design <- read.table(system.file("extdata", "design_diabete_example.txt",
                                   package = "ASICSdata"), header = TRUE)
  design$condition <- factor(design$condition)

  # Create object for analysis and remove features with more than 25\% of
  # zeros
  analysis_obj <- formatForAnalysis(quantification,
                                    zero.threshold = 25, design = design)
  res_oplsda <- oplsda(analysis_obj, "condition", orthoI = 1)
}

}
\references{
Trygg, J. and Wold, S. (2002). Orthogonal projections to latent
structures (O-PLS). \emph{Journal of Chemometrics}, \strong{16}(3), 119–128.

Thevenot, E.A., Roux, A., Xu, Y., Ezan, E., Junot, C. 2015.
Analysis of the human adult urinary metabolome variations with age, body mass
index and gender by implementing a comprehensive workflow for univariate and
OPLS statistical analyses. \emph{Journal of Proteome Research}.
\strong{14}:3322-3335.
}
\seealso{
\linkS4class{AnalysisResults}
}
