% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\docType{class}
\name{cacomp-class}
\alias{cacomp-class}
\alias{new_cacomp}
\title{An S4 class that contains all elements needed for CA.}
\usage{
new_cacomp(...)
}
\arguments{
\item{...}{slot names and objects for new cacomp object.}
}
\value{
cacomp object
}
\description{
This class contains elements necessary to computer CA coordinates or 
Association Plot coordinates,
as well as other informative data such as row/column inertia, 
gene-wise APL-scores, etc. ...

Creates new cacomp object.
}
\section{Slots}{

\describe{
\item{\code{U}}{class "matrix". Left singular vectors of the original input matrix.}

\item{\code{V}}{class "matrix". Right singular vectors of the original input matrix.}

\item{\code{D}}{class "numeric". Singular values of the original inpt matrix.}

\item{\code{std_coords_rows}}{class "matrix". Standardized CA coordinates of the 
rows.}

\item{\code{std_coords_cols}}{class "matrix". Standardized CA coordinates of the 
columns.}

\item{\code{prin_coords_rows}}{class "matrix". Principal CA coordinates of the rows.}

\item{\code{prin_coords_cols}}{class "matrix". Principal CA coordinates of the 
columns.}

\item{\code{apl_rows}}{class "matrix". Association Plot coordinates of the rows 
for the direction defined in slot "group"}

\item{\code{apl_cols}}{class "matrix". Association Plot coordinates of the columns 
for the direction defined in slot "group"}

\item{\code{APL_score}}{class "data.frame". Contains rows sorted by the APL score.
Columns: Rowname (gene name in the case of gene expression data),
APL score calculated for the direction defined in slot "group",
the original row number and the rank of the row as determined by the score.}

\item{\code{dims}}{class "numeric". Number of dimensions in CA space.}

\item{\code{group}}{class "numeric". Indices of the chosen columns for APL 
calculations.}

\item{\code{row_masses}}{class "numeric". Row masses of the frequency table.}

\item{\code{col_masses}}{class "numeric". Column masses of the frequency table.}

\item{\code{top_rows}}{class "numeric". Number of most variable rows chosen.}

\item{\code{tot_inertia}}{class "numeric". Total inertia in CA space.}

\item{\code{row_inertia}}{class "numeric". Row-wise inertia in CA space.}

\item{\code{col_inertia}}{class "numeric". Column-wise inertia in CA space.}

\item{\code{permuted_data}}{class "list". Storage slot for permuted data.}

\item{\code{params}}{class "list". List of parameters.}
}}

\examples{
set.seed(1234)

# Simulate counts
cnts <- mapply(function(x){rpois(n = 500, lambda = x)}, 
               x = sample(1:20, 50, replace = TRUE))
rownames(cnts) <- paste0("gene_", 1:nrow(cnts))
colnames(cnts) <- paste0("cell_", 1:ncol(cnts))

res <-  APL:::comp_std_residuals(mat=cnts)
SVD <- svd(res$S)
names(SVD) <- c("D", "U", "V")
SVD <- SVD[c(2, 1, 3)]

ca <- new_cacomp(U = SVD$U,
                 V = SVD$V,
                 D = SVD$D,
                 row_masses = res$rowm,
                 col_masses = res$colm)
}
