% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sanity_check.R
\name{data_sanity_check}
\alias{data_sanity_check}
\title{Data Sanity and Integrity Check}
\usage{
data_sanity_check(
  data,
  taxa_are_rows = TRUE,
  assay.type = assay_name,
  assay_name = "counts",
  rank = tax_level,
  tax_level = NULL,
  aggregate_data = NULL,
  meta_data = NULL,
  fix_formula,
  group = NULL,
  struc_zero = FALSE,
  global = FALSE,
  pairwise = FALSE,
  dunnet = FALSE,
  mdfdr_control = list(fwer_ctrl_method = "holm", B = 100),
  trend = FALSE,
  trend_control = list(contrast = NULL, node = NULL, solver = "ECOS", B = 100),
  verbose = TRUE
)
}
\arguments{
\item{data}{the input data. The \code{data} parameter should be either a
\code{matrix}, \code{data.frame}, \code{phyloseq} or a \code{TreeSummarizedExperiment}
object. Both \code{phyloseq} and \code{TreeSummarizedExperiment} objects
consist of a feature table (microbial count table), a sample metadata table,
a taxonomy table (optional), and a phylogenetic tree (optional).
If a \code{matrix} or \code{data.frame} is provided, ensure that the row
names of the \code{metadata} match the sample names (column names if
\code{taxa_are_rows} is TRUE, and row names otherwise) in \code{data}.
if a \code{phyloseq} or a \code{TreeSummarizedExperiment} is used, this
standard has already been enforced. For detailed information, refer to
\code{?phyloseq::phyloseq} or
\code{?TreeSummarizedExperiment::TreeSummarizedExperiment}.
It is recommended to use low taxonomic levels, such as OTU or species level,
as the estimation of sampling fractions requires a large number of taxa.}

\item{taxa_are_rows}{logical. Whether taxa are positioned in the rows of the
feature table. Default is TRUE.}

\item{assay.type}{alias for \code{assay_name}.}

\item{assay_name}{character. Name of the count table in the data object
(only applicable if data object is a \code{(Tree)SummarizedExperiment}).
Default is "counts".
See \code{?SummarizedExperiment::assay} for more details.}

\item{rank}{alias for \code{tax_level}.}

\item{tax_level}{character. The taxonomic or non taxonomic(rowData) level of interest. The input data
can be analyzed at any taxonomic or rowData level without prior agglomeration.
Note that \code{tax_level} must be a value from \code{taxonomyRanks} or \code{rowData}, which
includes "Kingdom", "Phylum" "Class", "Order", "Family" "Genus" "Species" etc.
See \code{?mia::taxonomyRanks} for more details.
Default is NULL, i.e., do not perform agglomeration, and the
ANCOM-BC2 analysis will be performed at the lowest taxonomic level of the
input \code{data}.}

\item{aggregate_data}{The abundance data that has been aggregated to the desired
taxonomic level. This parameter is required only when the input data is in
\code{matrix} or \code{data.frame} format. For \code{phyloseq} or \code{TreeSummarizedExperiment}
data, aggregation is performed by specifying the \code{tax_level} parameter.}

\item{meta_data}{a \code{data.frame} containing sample metadata.
This parameter is mandatory when the input \code{data} is a generic
\code{matrix} or \code{data.frame}. Ensure that the row names of the \code{metadata} match the
sample names (column names if \code{taxa_are_rows} is TRUE, and row names
otherwise) in \code{data}.}

\item{fix_formula}{the character string expresses how the microbial absolute
abundances for each taxon depend on the fixed effects in metadata. When
specifying the \code{fix_formula}, make sure to include the \code{group}
variable in the formula if it is not NULL.}

\item{group}{character. the name of the group variable in metadata.
The \code{group} parameter should be a character string representing the name
of the group variable in the metadata. The \code{group} variable should be
discrete, meaning it consists of categorical values. Specifying the
\code{group} variable is required if you are interested in detecting
structural zeros and performing performing multi-group comparisons (global
test, pairwise directional test, Dunnett's type of test, and trend test).
However, if these analyses are not of interest to you, you can leave the
\code{group} parameter as NULL. If the \code{group} variable of interest
contains only two categories, you can also leave the \code{group} parameter
as NULL. Default is NULL.}

\item{struc_zero}{logical. Whether to detect structural zeros based on
\code{group}. Default is FALSE. See \code{Details} for
a more comprehensive discussion on structural zeros.}

\item{global}{logical. Whether to perform the global test. Default is FALSE.}

\item{pairwise}{logical. Whether to perform the pairwise directional test.
Default is FALSE.}

\item{dunnet}{logical. Whether to perform the Dunnett's type of test.
Default is FALSE.}

\item{mdfdr_control}{a named list of control parameters for mixed directional
false discover rate (mdFDR), including 1) \code{fwer_ctrl_method}: family
wise error (FWER) controlling procedure, such as "holm", "hochberg",
"bonferroni", etc (default is "holm") and 2) \code{B}: the number of
bootstrap samples (default is 100). Increase \code{B} will lead to a more
accurate p-values. See \code{Details} for a more comprehensive discussion on
mdFDR.}

\item{trend}{logical. Whether to perform trend test. Default is FALSE.}

\item{trend_control}{a named list of control parameters for the trend test,
including 1) \code{contrast}: the list of contrast matrices for
constructing inequalities, 2) \code{node}: the list of positions for the
nodal parameter, 3) \code{solver}: a string indicating the solver to use
(default is "ECOS"), and 4) \code{B}: the number of bootstrap samples
(default is 100). Increase \code{B} will lead to a more accurate p-values.
See \code{vignette} for the corresponding trend test examples.}

\item{verbose}{logical. Whether to display detailed progress messages.}
}
\value{
a \code{list} containing the outputs formatted appropriately for
downstream analysis.
}
\description{
Determine if the input data is in a correct format
}
\examples{
data(atlas1006, package = "microbiome")
check_results = data_sanity_check(data = atlas1006,
                                  tax_level = "Family",
                                  fix_formula = "age + sex + bmi_group",
                                  group = "bmi_group",
                                  struc_zero = TRUE,
                                  global = TRUE,
                                  verbose = TRUE)

}
\author{
Huang Lin
}
