% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAIN.R
\name{twolayernetworkSimulation}
\alias{twolayernetworkSimulation}
\title{Illustration of two-layer weighted network simulation}
\usage{
twolayernetworkSimulation(n1, k1, theta1, n2, k2, theta2)
}
\arguments{
\item{n1}{number of nodes in the network1}

\item{k1}{number of nodes in the module1, n1 < k1}

\item{theta1}{module1 node score follow the uniform distribution in range [theta1,1]}

\item{n2}{number of nodes in the network2}

\item{k2}{number of nodes in the module2, n2 < k2}

\item{theta2}{module2 node score follow the uniform distribution in range [theta2,1]}
}
\value{
a list containing network1, network2 and a inter-layer links matrix
}
\description{
Simulate a two-layer weighted network
}
\examples{
n1=100
k1=20
theta1 = 0.5
n2=80
k2=10
theta2 = 0.5
ppresult <- twolayernetworkSimulation(n1,k1,theta1,n2,k2,theta2)
A <- ppresult[[3]]
pp <- ppresult[[1]]
moduleid <- pp[[3]]
netid <- 1:n1
restp<- netid[-moduleid]
pp2 <- ppresult[[2]]
moduleid2 <- pp2[[3]]
netid2 <- 1:n2
restp2<- netid2[-moduleid2]
## labelling the groups
groupdesign=list(moduleid,restp,(moduleid2+n1),(restp2+n1))
names(groupdesign)=c('module1','background1','module2','background2')
twolayernet<-matrix(0,nrow=(n1+n2),ncol=(n1+n2))
twolayernet[1:n1,1:n1]<-pp[[1]]
twolayernet[(n1+1):(n1+n2),(n1+1):(n1+n2)]<-pp2[[1]]
twolayernet[1:n1,(n1+1):(n1+n2)] = A
twolayernet[(n1+1):(n1+n2),1:n1] = t(A)
\dontrun{library(qgraph)
g<-qgraph(twolayernet,groups=groupdesign,legend=TRUE)}
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\seealso{
\code{\link{networkSimulation}}
}
\keyword{simulation}

