% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amaretto_download.R
\name{AMARETTO_ExportResults}
\alias{AMARETTO_ExportResults}
\title{AMARETTO_ExportResults}
\usage{
AMARETTO_ExportResults(AMARETTOinit, AMARETTOresults, data_address,
  Heatmaps = TRUE, CNV_matrix = NULL, MET_matrix = NULL)
}
\arguments{
\item{AMARETTOinit}{AMARETTO initialize output}

\item{AMARETTOresults}{AMARETTO results output}

\item{data_address}{Directory to save data folder}

\item{Heatmaps}{Output heatmaps as pdf}

\item{CNV_matrix}{CNV_matrix}

\item{MET_matrix}{MET_matrix}
}
\value{
result
}
\description{
Retrieve a download of all the data linked with the run (including heatmaps)
}
\examples{
data('ProcessedDataLIHC')
TargetDirectory <- file.path(getwd(),"Downloads/");dir.create(TargetDirectory)
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    NrModules = 2, VarPercentage = 50)

AMARETTOresults <- AMARETTO_Run(AMARETTOinit)
AMARETTO_ExportResults(AMARETTOinit,AMARETTOresults,TargetDirectory,Heatmaps = FALSE)
}
