% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summary,DAresult-method}
\alias{summary,DAresult-method}
\title{Summary of differential abundance analysis}
\usage{
\S4method{summary}{DAresult}(object, select = c("all", "da", "ref"))
}
\arguments{
\item{object}{analysis result in \code{DAresult} type}

\item{select}{Taxa whose results to be returned, can be all the taxa ("all"),
only the differentially abundant taxa ("da") or reference taxa ("ref").}
}
\value{
A dataframe with detailed analysis results
}
\description{
Summary function for \code{DAresult} type object
}
\details{
This customized summary function reports the dimension of input count table,
number of reference taxa and number of differentially abundant taxa. It also returns
a data frame with the detailed analysis result and taxonomy of all the taxa. The
user can choose to only get the detailed analysis result of DA taxa or the reference taxa
through the \code{select} parameter.
}
\examples{
data(ecc_saliva)
saliva_results <- adapt(input_data=ecc_saliva, cond.var="CaseStatus", 
       base.cond="Control", adj.var="Site")
summary(saliva_results, select="da")
}
