#' @title Aedes aegypti RNA-seq differential expression data example
#' @description  A sample fragment of differential gene expression from an
#' RNA-seq experiment of Aedes aegypti mosquito.
#' @format A data.frame with 1973 rows and 3 variables
#' @name DiffAedes
#' @references AKBARI, O. S. et al. The developmental transcriptome of the
#' mosquito aedes aegypti, an invasive species and major arbovirus vector.
#' G3: Genes— Genomes— Genetics, Genetics Society of America, v. 3, n. 9,
#' p. 1493–1509, 2013.
#' @examples
#' data(DiffAedes)
NULL

#' @title Relation between Aedes aegypti genes and KEGG pathways
#' @description A relation between the GFAGs present in ResultAnalysisAedes and
#' their respective genes.
#' @format A data.frame with 782 rows and 2 variables
#' @name GeneFunctionAedes
#' @references Molan, A. L. 2018. “Construction of a Tool for Multispecies Genic
#' Functional Enrichment Analysis Among Comparative Samples.” Master’s thesis,
#' Institute of Biosciences of Botucatu – Univ. Estadual Paulista.
#' http://hdl.handle.net/11449/157105.
#' @examples
#' data(GeneFunctionAedes)
NULL

#' @title Result from an example of ADAM Aedes aegypti analysis
#' @description Result from ADAM Aedes aegypti analysis according to
#' ExpressionAedes data.
#' @format A data.frame with 87 rows and 22 variables
#' @name ResultAnalysisAedes
#' @references Molan, A. L. 2018. “Construction of a Tool for Multispecies Genic
#' Functional Enrichment Analysis Among Comparative Samples.” Master’s thesis,
#' Institute of Biosciences of Botucatu – Univ. Estadual Paulista.
#' http://hdl.handle.net/11449/157105.
#' @examples
#' data(ResultAnalysisAedes)
NULL
