% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allowExternalSeeds.R
\name{allowExternalSeeds}
\alias{allowExternalSeeds}
\title{Allow saving of external seeds}
\usage{
allowExternalSeeds(allow)
}
\arguments{
\item{allow}{Logical scalar indicating whether to allow downloads of external seeds.}
}
\value{
If \code{allow} is not supplied, the current value of this flag is returned.

If \code{allow} is supplied, it is used to define the value of this flag, and the \emph{previous} value of the flag is returned.
}
\description{
Should external array seeds be saved in \code{\link{saveDelayed}}?
If \code{FALSE}, an error is raised upon encountering external references such as \linkS4class{HDF5ArraySeed}s.
This prevents the creation of delayed objects that cannot be used on different filesystems.
}
\examples{
allowExternalSeeds()

a <- allowExternalSeeds(FALSE)
allowExternalSeeds()

# Setting it back
allowExternalSeeds(a)

}
\author{
Aaron Lun
}
