% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedSubset.R
\name{saveDelayedObject,DelayedSubset-method}
\alias{saveDelayedObject,DelayedSubset-method}
\title{Saving a DelayedSubset}
\usage{
\S4method{saveDelayedObject}{DelayedSubset}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedSubset} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedSubset.
}
\description{
Save a \linkS4class{DelayedSubset} object into a HDF5 file.
See the \dQuote{Subsetting} operation at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- X[1:2,3:5]
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
