% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedSetDimnames.R
\name{saveDelayedObject,DelayedSetDimnames-method}
\alias{saveDelayedObject,DelayedSetDimnames-method}
\title{Saving a DelayedSetDimnames}
\usage{
\S4method{saveDelayedObject}{DelayedSetDimnames}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedSetDimnames} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedSetDimnames.
}
\description{
Save a \linkS4class{DelayedSetDimnames} object.
See the \dQuote{Dimnames assignment} operation at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
colnames(X) <- LETTERS[1:20]
temp <- tempfile(fileext=".h5")
saveDelayed(X, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
