% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConstantArraySeed.R
\name{saveDelayedObject,ConstantArraySeed-method}
\alias{saveDelayedObject,ConstantArraySeed-method}
\title{Saving a ConstantArraySeed}
\usage{
\S4method{saveDelayedObject}{ConstantArraySeed}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{ConstantArraySeed} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the ConstantArraySeed.
}
\description{
Save a \linkS4class{ConstantArraySeed} object.
See the \dQuote{Constant array} section at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- ConstantArray(value=NA_real_, dim=c(11, 25))
temp <- tempfile(fileext=".h5")
saveDelayed(X, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
