\name{mergeMCRProbes}
\alias{mergeMCRProbes}
\title{A function that appends probe ids to a data frame containing MCRs}
\description{
  This function takes a data frame generated by \code{\link{MCR}} and
  then append probe ids corresponding to each MCR as a column to the
  data frame.
}
\usage{
mergeMCRProbes(mcr, rawData)
}
\arguments{
  \item{mcr}{\code{mcr} is a data frame generated by \code{\link{MCR}}
      that contains MCRs identified and other related data}
  \item{rawData}{\code{rawData} is a data frame with at least three
    columns. The first column should be probe ids, second the chromosome
    number the probes corresponding to, and the thrid the starting or
    ending chromosomal locations of the probes} 
}
\details{
  The \code{mcr} data frame passed must have the first column for
  chromosome numbers, the 7th column for the starting positions of
  the MCRs, and the 8th column for the ending positions of the MCRs.
}
\value{
  A data frame with MCRs and the corresponding probe ids and other data.
}
\author{Jianhua Zhang}
\note{The function is a contribution of The Center for Applied Cancer
  Science of Dana-Farber Cancer Institute}
\seealso{\code{\link{MCR}}}
\examples{
  data("segData")
  cghmcr <- cghMCR(segData, gapAllowed = 500, alteredLow = 0.20,
                   alteredHigh = 0.80, recurrence = 50)
  mcrs <- MCR(cghmcr)
  mcrs <- mergeMCRProbes(mcrs, segData[["data"]])
}
\keyword{manip}
