% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_internal_v3.R
\name{fixDA}
\alias{fixDA}
\title{Direction AutoCorrelation}
\usage{
fixDA(Object, Step, sLAG, sPLOT, aPLOT, color, export, ExpName, new.fld)
}
\arguments{
\item{Step}{A numeric value of the number of trajectory steps.}

\item{sLAG}{A numeric value to be used to get the number of lags
for the slope fitting. Default is 0.25, which represents 25
percent of the steps.}

\item{sPLOT}{A logical vector that allows generating individual
plots showing the angular persistence across several sequantial
time intervals. Default is TRUE.}

\item{aPLOT}{A logical vector that allows generating a plot
showing the angular persistence across several sequantial time
intervals of all cells. Default is TRUE.}

\item{color}{A vector of colors that will be used for the plots}

\item{export}{if `TRUE` (default), exports function output}

\item{ExpName}{String, name of the experiment}

\item{new.fld}{path to the folder where to save files}

\item{object}{\code{CellMig} class object, which is a list
of data frames resulted from the PreProcessing.}
}
\value{
A data frame named "DA.ResultsTable".
}
\description{
This function is a part of the DiAutoCor function, which
computes the angular persistence across several sequantial time intervals.
}
\examples{
cellmigRation:::fixDA(1, 1, 1, 1, 1, 1, 1, 1, 1)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
\keyword{internal}
