% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{CentroidArray}
\alias{CentroidArray}
\title{Build a Centroid Array}
\usage{
CentroidArray(stack, lobject, threshold, dryrun = FALSE)
}
\arguments{
\item{stack}{3D matrix loaded to workspace from .tif stack}

\item{lobject}{Integer length in pixels somewhat larger
than a typical object}

\item{threshold}{the minimum brightness of a pixel that might be
local maxima}

\item{dryrun}{logical, shall the execution be skipped}
}
\value{
data.frame of centroids, with 4 columns corresponding to
x-position of centroid,
y-postion of centroid, brightness, and square of the radius
of gyration
}
\description{
Create an array containing centroid data for particles identified
in each frame of the imported TIFF image stack
}
\examples{
# by default, the dryrun argument is set to FALSE
df <- get(data(TrackCellsDataset))
x0 <- getCellImages(df)
y0 <- cellmigRation:::CentroidArray(x0, 16, 10, TRUE)
y0


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
