% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariant-methods.R
\name{getVariant,CellBaseR-method}
\alias{getVariant,CellBaseR-method}
\alias{getVariant}
\title{getVariant}
\usage{
\S4method{getVariant}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of the ids to be queried, must be in the 
following format 'chr:start:ref:alt', for 
example, '1:128546:A:T'}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param
for the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query variant annotation data from Cellbase web services from
 Cellbase web services.
}
\details{
This method retrieves extensive genomic annotations for variants
including consequence types, conservation data, population frequncies from 1k
 genomes and Exac projects, etc.
as well as clinical data and various other annotations
}
\examples{
   cb <- CellBaseR()
   res <- getVariant(object=cb, ids="19:45411941:T:C", resource="annotation")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
