% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{pub.theme}
\alias{pub.theme}
\title{Define a publication-style plot theme}
\usage{
pub.theme(size = 12)
}
\arguments{
\item{size}{numeric, base font size for adapted ggplot2 theme}
}
\value{
a ggplot theme based on theme_classic
}
\description{
Define a publication-style plot theme
}
\details{
This theme modifies the \code{\link[ggplot2]{theme_classic}} theme
in ggplot2.
}
\examples{
library(ggplot2)
x <- sample(10)
y <- x + runif(10) - 0.5
df <- data.frame(x = x, y = y)
fig <- ggplot(df, aes(x = x, y = y)) +
    geom_point() +
    pub.theme()
}
