% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{load_cellSNP_vcf}
\alias{load_cellSNP_vcf}
\title{Load sparse matrices A and D from cellSNP VCF file with filtering SNPs}
\usage{
load_cellSNP_vcf(
  vcf_file,
  min_count = 0,
  min_MAF = 0,
  max_other_allele = NULL,
  rowname_format = "full",
  keep_GL = FALSE
)
}
\arguments{
\item{vcf_file}{character(1), path to VCF file generated from cellSNP}

\item{min_count}{minimum count across all cells, e.g., 20}

\item{min_MAF}{minimum minor allele fraction, e.g., 0.1}

\item{max_other_allele}{maximum ratio of other alleles comparing to REF and
ALT alleles; for cellSNP vcf, we recommend 0.05}

\item{rowname_format}{the format of rowname: NULL is the default from vcfR,
short is CHROM_POS, and full is CHROM_POS_REF_ALT}

\item{keep_GL}{logical(1), if TRUE, check if GL (genotype probability) exists
it will be returned}
}
\value{
A list with elements the matrices A and D and GL, the genotype 
  probability. If keep_GL is false the GL element will be an empty list.
}
\description{
Load sparse matrices A and D from cellSNP VCF file with filtering SNPs
}
\examples{
vcf_file <- system.file("extdata", "cellSNP.cells.vcf.gz",
    package = "cardelino"
)
input_data <- load_cellSNP_vcf(vcf_file)
}
