# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Read raw BRENDA text file.
#'
#' @description
#'   Read file into buffer, and load all non-empty lines. Comment lines
#'   (starting with *) are skipped. The text file should be downloaded from
#'   https://www.brenda-enzymes.org/download_brenda_without_registration.php
#'
#' @param filepath A string indicating the path to the text file.
#'
#' @return A vector<string> with each element being a line in the file.
ReadBrendaFile <- function(filepath) {
    .Call('_brendaDb_ReadBrendaFile', PACKAGE = 'brendaDb', filepath)
}

#' @title Convert vector of lines to matrix.
#'
#' @description
#' For each EC entry, split the annotations into three columns:
#' - ID: EC number, e.g. 1.1.1.1
#' - field: the content of the information, e.g. protein, localization
#' - description: everything else
#'
#' @param lines The output vector<string> from `read_brenda_file`.
#'
#' @return A vector<vector<string>> containing information about the EC
#' entries. In R this is a list of 3 lists.
SeparateEntries <- function(lines) {
    .Call('_brendaDb_SeparateEntries', PACKAGE = 'brendaDb', lines)
}

